<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRatePlanType extends AbstractStructBase
{
    /**
     * The Guarantee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Guarantee;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The RatePlanDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType
     */
    public $RatePlanDescription;
    /**
     * The RatePlanInclusion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRatePlanInclusion[]
     */
    public $RatePlanInclusion;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCommissionType
     */
    public $Commission;
    /**
     * The MealsIncluded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMealsIncluded
     */
    public $MealsIncluded;
    /**
     * The RestrictionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRestrictionStatus
     */
    public $RestrictionStatus;
    /**
     * The AdditionalDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAdditionalDetailType
     */
    public $AdditionalDetails;
    /**
     * The BookingCode
     * @var string
     */
    public $BookingCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The RateIndicator
     * @var string
     */
    public $RateIndicator;
    /**
     * The RatePlanType
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanName
     * @var string
     */
    public $RatePlanName;
    /**
     * The MarketCode
     * @var string
     */
    public $MarketCode;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The ID_RequiredInd
     * @var bool
     */
    public $ID_RequiredInd;
    /**
     * The PriceViewableInd
     * @var bool
     */
    public $PriceViewableInd;
    /**
     * The QualificationType
     * @var string
     */
    public $QualificationType;
    /**
     * Constructor method for RatePlanType
     * @uses DgRatePlanType::setGuarantee()
     * @uses DgRatePlanType::setCancelPenalties()
     * @uses DgRatePlanType::setRatePlanDescription()
     * @uses DgRatePlanType::setRatePlanInclusion()
     * @uses DgRatePlanType::setCommission()
     * @uses DgRatePlanType::setMealsIncluded()
     * @uses DgRatePlanType::setRestrictionStatus()
     * @uses DgRatePlanType::setAdditionalDetails()
     * @uses DgRatePlanType::setBookingCode()
     * @uses DgRatePlanType::setRatePlanCode()
     * @uses DgRatePlanType::setEffectiveDate()
     * @uses DgRatePlanType::setExpireDate()
     * @uses DgRatePlanType::setRateIndicator()
     * @uses DgRatePlanType::setRatePlanType()
     * @uses DgRatePlanType::setRatePlanID()
     * @uses DgRatePlanType::setRatePlanName()
     * @uses DgRatePlanType::setMarketCode()
     * @uses DgRatePlanType::setAvailabilityStatus()
     * @uses DgRatePlanType::setID_RequiredInd()
     * @uses DgRatePlanType::setPriceViewableInd()
     * @uses DgRatePlanType::setQualificationType()
     * @param string[] $guarantee
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties
     * @param \dgsoft\StructType\DgParagraphType $ratePlanDescription
     * @param \dgsoft\StructType\DgRatePlanInclusion[] $ratePlanInclusion
     * @param \dgsoft\StructType\DgCommissionType $commission
     * @param \dgsoft\StructType\DgMealsIncluded $mealsIncluded
     * @param \dgsoft\StructType\DgRestrictionStatus $restrictionStatus
     * @param \dgsoft\ArrayType\DgArrayOfAdditionalDetailType $additionalDetails
     * @param string $bookingCode
     * @param string $ratePlanCode
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $rateIndicator
     * @param string $ratePlanType
     * @param string $ratePlanID
     * @param string $ratePlanName
     * @param string $marketCode
     * @param string $availabilityStatus
     * @param bool $iD_RequiredInd
     * @param bool $priceViewableInd
     * @param string $qualificationType
     */
    public function __construct(array $guarantee = array(), \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties = null, \dgsoft\StructType\DgParagraphType $ratePlanDescription = null, array $ratePlanInclusion = array(), \dgsoft\StructType\DgCommissionType $commission = null, \dgsoft\StructType\DgMealsIncluded $mealsIncluded = null, \dgsoft\StructType\DgRestrictionStatus $restrictionStatus = null, \dgsoft\ArrayType\DgArrayOfAdditionalDetailType $additionalDetails = null, $bookingCode = null, $ratePlanCode = null, $effectiveDate = null, $expireDate = null, $rateIndicator = null, $ratePlanType = null, $ratePlanID = null, $ratePlanName = null, $marketCode = null, $availabilityStatus = null, $iD_RequiredInd = null, $priceViewableInd = null, $qualificationType = null)
    {
        $this
            ->setGuarantee($guarantee)
            ->setCancelPenalties($cancelPenalties)
            ->setRatePlanDescription($ratePlanDescription)
            ->setRatePlanInclusion($ratePlanInclusion)
            ->setCommission($commission)
            ->setMealsIncluded($mealsIncluded)
            ->setRestrictionStatus($restrictionStatus)
            ->setAdditionalDetails($additionalDetails)
            ->setBookingCode($bookingCode)
            ->setRatePlanCode($ratePlanCode)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setRateIndicator($rateIndicator)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanName($ratePlanName)
            ->setMarketCode($marketCode)
            ->setAvailabilityStatus($availabilityStatus)
            ->setID_RequiredInd($iD_RequiredInd)
            ->setPriceViewableInd($priceViewableInd)
            ->setQualificationType($qualificationType);
    }
    /**
     * Get Guarantee value
     * @return string[]|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @uses \dgsoft\EnumType\DgGuaranteeType::valueIsValid()
     * @uses \dgsoft\EnumType\DgGuaranteeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $guarantee
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setGuarantee(array $guarantee = array())
    {
        $invalidValues = array();
        foreach ($guarantee as $ratePlanTypeGuaranteeItem) {
            if (!\dgsoft\EnumType\DgGuaranteeType::valueIsValid($ratePlanTypeGuaranteeItem)) {
                $invalidValues[] = var_export($ratePlanTypeGuaranteeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \dgsoft\EnumType\DgGuaranteeType::getValidValues())), __LINE__);
        }
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Add item to Guarantee value
     * @uses \dgsoft\EnumType\DgGuaranteeType::valueIsValid()
     * @uses \dgsoft\EnumType\DgGuaranteeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function addToGuarantee($item)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgGuaranteeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \dgsoft\EnumType\DgGuaranteeType::getValidValues())), __LINE__);
        }
        $this->Guarantee[] = $item;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \dgsoft\StructType\DgCancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setCancelPenalties(\dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get RatePlanDescription value
     * @return \dgsoft\StructType\DgParagraphType|null
     */
    public function getRatePlanDescription()
    {
        return $this->RatePlanDescription;
    }
    /**
     * Set RatePlanDescription value
     * @param \dgsoft\StructType\DgParagraphType $ratePlanDescription
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setRatePlanDescription(\dgsoft\StructType\DgParagraphType $ratePlanDescription = null)
    {
        $this->RatePlanDescription = $ratePlanDescription;
        return $this;
    }
    /**
     * Get RatePlanInclusion value
     * @return \dgsoft\StructType\DgRatePlanInclusion[]|null
     */
    public function getRatePlanInclusion()
    {
        return $this->RatePlanInclusion;
    }
    /**
     * Set RatePlanInclusion value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRatePlanInclusion[] $ratePlanInclusion
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setRatePlanInclusion(array $ratePlanInclusion = array())
    {
        foreach ($ratePlanInclusion as $ratePlanTypeRatePlanInclusionItem) {
            // validation for constraint: itemType
            if (!$ratePlanTypeRatePlanInclusionItem instanceof \dgsoft\StructType\DgRatePlanInclusion) {
                throw new \InvalidArgumentException(sprintf('The RatePlanInclusion property can only contain items of \dgsoft\StructType\DgRatePlanInclusion, "%s" given', is_object($ratePlanTypeRatePlanInclusionItem) ? get_class($ratePlanTypeRatePlanInclusionItem) : gettype($ratePlanTypeRatePlanInclusionItem)), __LINE__);
            }
        }
        $this->RatePlanInclusion = $ratePlanInclusion;
        return $this;
    }
    /**
     * Add item to RatePlanInclusion value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRatePlanInclusion $item
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function addToRatePlanInclusion(\dgsoft\StructType\DgRatePlanInclusion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRatePlanInclusion) {
            throw new \InvalidArgumentException(sprintf('The RatePlanInclusion property can only contain items of \dgsoft\StructType\DgRatePlanInclusion, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RatePlanInclusion[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \dgsoft\StructType\DgCommissionType|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \dgsoft\StructType\DgCommissionType $commission
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setCommission(\dgsoft\StructType\DgCommissionType $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get MealsIncluded value
     * @return \dgsoft\StructType\DgMealsIncluded|null
     */
    public function getMealsIncluded()
    {
        return $this->MealsIncluded;
    }
    /**
     * Set MealsIncluded value
     * @param \dgsoft\StructType\DgMealsIncluded $mealsIncluded
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setMealsIncluded(\dgsoft\StructType\DgMealsIncluded $mealsIncluded = null)
    {
        $this->MealsIncluded = $mealsIncluded;
        return $this;
    }
    /**
     * Get RestrictionStatus value
     * @return \dgsoft\StructType\DgRestrictionStatus|null
     */
    public function getRestrictionStatus()
    {
        return $this->RestrictionStatus;
    }
    /**
     * Set RestrictionStatus value
     * @param \dgsoft\StructType\DgRestrictionStatus $restrictionStatus
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setRestrictionStatus(\dgsoft\StructType\DgRestrictionStatus $restrictionStatus = null)
    {
        $this->RestrictionStatus = $restrictionStatus;
        return $this;
    }
    /**
     * Get AdditionalDetails value
     * @return \dgsoft\ArrayType\DgArrayOfAdditionalDetailType|null
     */
    public function getAdditionalDetails()
    {
        return $this->AdditionalDetails;
    }
    /**
     * Set AdditionalDetails value
     * @param \dgsoft\ArrayType\DgArrayOfAdditionalDetailType $additionalDetails
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setAdditionalDetails(\dgsoft\ArrayType\DgArrayOfAdditionalDetailType $additionalDetails = null)
    {
        $this->AdditionalDetails = $additionalDetails;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get RateIndicator value
     * @return string|null
     */
    public function getRateIndicator()
    {
        return $this->RateIndicator;
    }
    /**
     * Set RateIndicator value
     * @uses \dgsoft\EnumType\DgRateIndicatorType::valueIsValid()
     * @uses \dgsoft\EnumType\DgRateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rateIndicator
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setRateIndicator($rateIndicator = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRateIndicatorType::valueIsValid($rateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rateIndicator, implode(', ', \dgsoft\EnumType\DgRateIndicatorType::getValidValues())), __LINE__);
        }
        $this->RateIndicator = $rateIndicator;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanName value
     * @return string|null
     */
    public function getRatePlanName()
    {
        return $this->RatePlanName;
    }
    /**
     * Set RatePlanName value
     * @param string $ratePlanName
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setRatePlanName($ratePlanName = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanName) && !is_string($ratePlanName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanName)), __LINE__);
        }
        $this->RatePlanName = $ratePlanName;
        return $this;
    }
    /**
     * Get MarketCode value
     * @return string|null
     */
    public function getMarketCode()
    {
        return $this->MarketCode;
    }
    /**
     * Set MarketCode value
     * @param string $marketCode
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketCode)), __LINE__);
        }
        $this->MarketCode = $marketCode;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \dgsoft\EnumType\DgRateIndicatorType::valueIsValid()
     * @uses \dgsoft\EnumType\DgRateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availabilityStatus, implode(', ', \dgsoft\EnumType\DgRateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get ID_RequiredInd value
     * @return bool|null
     */
    public function getID_RequiredInd()
    {
        return $this->ID_RequiredInd;
    }
    /**
     * Set ID_RequiredInd value
     * @param bool $iD_RequiredInd
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setID_RequiredInd($iD_RequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($iD_RequiredInd) && !is_bool($iD_RequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($iD_RequiredInd)), __LINE__);
        }
        $this->ID_RequiredInd = $iD_RequiredInd;
        return $this;
    }
    /**
     * Get PriceViewableInd value
     * @return bool|null
     */
    public function getPriceViewableInd()
    {
        return $this->PriceViewableInd;
    }
    /**
     * Set PriceViewableInd value
     * @param bool $priceViewableInd
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setPriceViewableInd($priceViewableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceViewableInd) && !is_bool($priceViewableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priceViewableInd)), __LINE__);
        }
        $this->PriceViewableInd = $priceViewableInd;
        return $this;
    }
    /**
     * Get QualificationType value
     * @return string|null
     */
    public function getQualificationType()
    {
        return $this->QualificationType;
    }
    /**
     * Set QualificationType value
     * @param string $qualificationType
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public function setQualificationType($qualificationType = null)
    {
        // validation for constraint: string
        if (!is_null($qualificationType) && !is_string($qualificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qualificationType)), __LINE__);
        }
        $this->QualificationType = $qualificationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRatePlanType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
