<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanInclusion StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRatePlanInclusion extends AbstractStructBase
{
    /**
     * The IsDaily
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDaily;
    /**
     * The IsPackage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPackage;
    /**
     * The IsPerPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPerPeriod;
    /**
     * The IsPerPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPerPerson;
    /**
     * The IsPerRoom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPerRoom;
    /**
     * The IsTaxIncluded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTaxIncluded;
    /**
     * The RatePlanInclusionDesciption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType
     */
    public $RatePlanInclusionDesciption;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The CategoryType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryType;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The Percentage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Percentage;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The ServiceFeeInclusive
     * @var bool
     */
    public $ServiceFeeInclusive;
    /**
     * Constructor method for RatePlanInclusion
     * @uses DgRatePlanInclusion::setIsDaily()
     * @uses DgRatePlanInclusion::setIsPackage()
     * @uses DgRatePlanInclusion::setIsPerPeriod()
     * @uses DgRatePlanInclusion::setIsPerPerson()
     * @uses DgRatePlanInclusion::setIsPerRoom()
     * @uses DgRatePlanInclusion::setIsTaxIncluded()
     * @uses DgRatePlanInclusion::setRatePlanInclusionDesciption()
     * @uses DgRatePlanInclusion::setAmount()
     * @uses DgRatePlanInclusion::setCategoryType()
     * @uses DgRatePlanInclusion::setCode()
     * @uses DgRatePlanInclusion::setCurrency()
     * @uses DgRatePlanInclusion::setPercentage()
     * @uses DgRatePlanInclusion::setTaxInclusive()
     * @uses DgRatePlanInclusion::setServiceFeeInclusive()
     * @param bool $isDaily
     * @param bool $isPackage
     * @param bool $isPerPeriod
     * @param bool $isPerPerson
     * @param bool $isPerRoom
     * @param bool $isTaxIncluded
     * @param \dgsoft\StructType\DgParagraphType $ratePlanInclusionDesciption
     * @param float $amount
     * @param string $categoryType
     * @param string $code
     * @param string $currency
     * @param float $percentage
     * @param bool $taxInclusive
     * @param bool $serviceFeeInclusive
     */
    public function __construct($isDaily = null, $isPackage = null, $isPerPeriod = null, $isPerPerson = null, $isPerRoom = null, $isTaxIncluded = null, \dgsoft\StructType\DgParagraphType $ratePlanInclusionDesciption = null, $amount = null, $categoryType = null, $code = null, $currency = null, $percentage = null, $taxInclusive = null, $serviceFeeInclusive = null)
    {
        $this
            ->setIsDaily($isDaily)
            ->setIsPackage($isPackage)
            ->setIsPerPeriod($isPerPeriod)
            ->setIsPerPerson($isPerPerson)
            ->setIsPerRoom($isPerRoom)
            ->setIsTaxIncluded($isTaxIncluded)
            ->setRatePlanInclusionDesciption($ratePlanInclusionDesciption)
            ->setAmount($amount)
            ->setCategoryType($categoryType)
            ->setCode($code)
            ->setCurrency($currency)
            ->setPercentage($percentage)
            ->setTaxInclusive($taxInclusive)
            ->setServiceFeeInclusive($serviceFeeInclusive);
    }
    /**
     * Get IsDaily value
     * @return bool
     */
    public function getIsDaily()
    {
        return $this->IsDaily;
    }
    /**
     * Set IsDaily value
     * @param bool $isDaily
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setIsDaily($isDaily = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDaily) && !is_bool($isDaily)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDaily)), __LINE__);
        }
        $this->IsDaily = $isDaily;
        return $this;
    }
    /**
     * Get IsPackage value
     * @return bool
     */
    public function getIsPackage()
    {
        return $this->IsPackage;
    }
    /**
     * Set IsPackage value
     * @param bool $isPackage
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setIsPackage($isPackage = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPackage) && !is_bool($isPackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPackage)), __LINE__);
        }
        $this->IsPackage = $isPackage;
        return $this;
    }
    /**
     * Get IsPerPeriod value
     * @return bool
     */
    public function getIsPerPeriod()
    {
        return $this->IsPerPeriod;
    }
    /**
     * Set IsPerPeriod value
     * @param bool $isPerPeriod
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setIsPerPeriod($isPerPeriod = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerPeriod) && !is_bool($isPerPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPerPeriod)), __LINE__);
        }
        $this->IsPerPeriod = $isPerPeriod;
        return $this;
    }
    /**
     * Get IsPerPerson value
     * @return bool
     */
    public function getIsPerPerson()
    {
        return $this->IsPerPerson;
    }
    /**
     * Set IsPerPerson value
     * @param bool $isPerPerson
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setIsPerPerson($isPerPerson = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerPerson) && !is_bool($isPerPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPerPerson)), __LINE__);
        }
        $this->IsPerPerson = $isPerPerson;
        return $this;
    }
    /**
     * Get IsPerRoom value
     * @return bool
     */
    public function getIsPerRoom()
    {
        return $this->IsPerRoom;
    }
    /**
     * Set IsPerRoom value
     * @param bool $isPerRoom
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setIsPerRoom($isPerRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerRoom) && !is_bool($isPerRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPerRoom)), __LINE__);
        }
        $this->IsPerRoom = $isPerRoom;
        return $this;
    }
    /**
     * Get IsTaxIncluded value
     * @return bool
     */
    public function getIsTaxIncluded()
    {
        return $this->IsTaxIncluded;
    }
    /**
     * Set IsTaxIncluded value
     * @param bool $isTaxIncluded
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setIsTaxIncluded($isTaxIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxIncluded) && !is_bool($isTaxIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxIncluded)), __LINE__);
        }
        $this->IsTaxIncluded = $isTaxIncluded;
        return $this;
    }
    /**
     * Get RatePlanInclusionDesciption value
     * @return \dgsoft\StructType\DgParagraphType|null
     */
    public function getRatePlanInclusionDesciption()
    {
        return $this->RatePlanInclusionDesciption;
    }
    /**
     * Set RatePlanInclusionDesciption value
     * @param \dgsoft\StructType\DgParagraphType $ratePlanInclusionDesciption
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setRatePlanInclusionDesciption(\dgsoft\StructType\DgParagraphType $ratePlanInclusionDesciption = null)
    {
        $this->RatePlanInclusionDesciption = $ratePlanInclusionDesciption;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CategoryType value
     * @return string|null
     */
    public function getCategoryType()
    {
        return $this->CategoryType;
    }
    /**
     * Set CategoryType value
     * @param string $categoryType
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setCategoryType($categoryType = null)
    {
        // validation for constraint: string
        if (!is_null($categoryType) && !is_string($categoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryType)), __LINE__);
        }
        $this->CategoryType = $categoryType;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get ServiceFeeInclusive value
     * @return bool|null
     */
    public function getServiceFeeInclusive()
    {
        return $this->ServiceFeeInclusive;
    }
    /**
     * Set ServiceFeeInclusive value
     * @param bool $serviceFeeInclusive
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public function setServiceFeeInclusive($serviceFeeInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceFeeInclusive) && !is_bool($serviceFeeInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($serviceFeeInclusive)), __LINE__);
        }
        $this->ServiceFeeInclusive = $serviceFeeInclusive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRatePlanInclusion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
