<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlanCandidate StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRatePlanCandidate extends AbstractStructBase
{
    /**
     * The HotelRefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef
     */
    public $HotelRefs;
    /**
     * The MealsIncluded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMealsIncluded
     */
    public $MealsIncluded;
    /**
     * The RatePlanType
     * @var string
     */
    public $RatePlanType;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanQualifier
     * @var bool
     */
    public $RatePlanQualifier;
    /**
     * The RatePlanCategory
     * @var string
     */
    public $RatePlanCategory;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for RatePlanCandidate
     * @uses DgRatePlanCandidate::setHotelRefs()
     * @uses DgRatePlanCandidate::setMealsIncluded()
     * @uses DgRatePlanCandidate::setRatePlanType()
     * @uses DgRatePlanCandidate::setRatePlanCode()
     * @uses DgRatePlanCandidate::setRatePlanID()
     * @uses DgRatePlanCandidate::setRatePlanQualifier()
     * @uses DgRatePlanCandidate::setRatePlanCategory()
     * @uses DgRatePlanCandidate::setRPH()
     * @param \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef $hotelRefs
     * @param \dgsoft\StructType\DgMealsIncluded $mealsIncluded
     * @param string $ratePlanType
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param bool $ratePlanQualifier
     * @param string $ratePlanCategory
     * @param string $rPH
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef $hotelRefs = null, \dgsoft\StructType\DgMealsIncluded $mealsIncluded = null, $ratePlanType = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanQualifier = null, $ratePlanCategory = null, $rPH = null)
    {
        $this
            ->setHotelRefs($hotelRefs)
            ->setMealsIncluded($mealsIncluded)
            ->setRatePlanType($ratePlanType)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanQualifier($ratePlanQualifier)
            ->setRatePlanCategory($ratePlanCategory)
            ->setRPH($rPH);
    }
    /**
     * Get HotelRefs value
     * @return \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef|null
     */
    public function getHotelRefs()
    {
        return $this->HotelRefs;
    }
    /**
     * Set HotelRefs value
     * @param \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef $hotelRefs
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public function setHotelRefs(\dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidateHotelRef $hotelRefs = null)
    {
        $this->HotelRefs = $hotelRefs;
        return $this;
    }
    /**
     * Get MealsIncluded value
     * @return \dgsoft\StructType\DgMealsIncluded|null
     */
    public function getMealsIncluded()
    {
        return $this->MealsIncluded;
    }
    /**
     * Set MealsIncluded value
     * @param \dgsoft\StructType\DgMealsIncluded $mealsIncluded
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public function setMealsIncluded(\dgsoft\StructType\DgMealsIncluded $mealsIncluded = null)
    {
        $this->MealsIncluded = $mealsIncluded;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanQualifier value
     * @return bool|null
     */
    public function getRatePlanQualifier()
    {
        return $this->RatePlanQualifier;
    }
    /**
     * Set RatePlanQualifier value
     * @param bool $ratePlanQualifier
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public function setRatePlanQualifier($ratePlanQualifier = null)
    {
        // validation for constraint: boolean
        if (!is_null($ratePlanQualifier) && !is_bool($ratePlanQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ratePlanQualifier)), __LINE__);
        }
        $this->RatePlanQualifier = $ratePlanQualifier;
        return $this;
    }
    /**
     * Get RatePlanCategory value
     * @return string|null
     */
    public function getRatePlanCategory()
    {
        return $this->RatePlanCategory;
    }
    /**
     * Set RatePlanCategory value
     * @param string $ratePlanCategory
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public function setRatePlanCategory($ratePlanCategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCategory) && !is_string($ratePlanCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCategory)), __LINE__);
        }
        $this->RatePlanCategory = $ratePlanCategory;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRatePlanCandidate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
