<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RadiusItem StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRadiusItem extends AbstractStructBase
{
    /**
     * The Index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Index;
    /**
     * The FromValue
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $FromValue;
    /**
     * The ToValue
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ToValue;
    /**
     * The MeasureUnit
     * @var string
     */
    public $MeasureUnit;
    /**
     * Constructor method for RadiusItem
     * @uses DgRadiusItem::setIndex()
     * @uses DgRadiusItem::setFromValue()
     * @uses DgRadiusItem::setToValue()
     * @uses DgRadiusItem::setMeasureUnit()
     * @param int $index
     * @param int $fromValue
     * @param int $toValue
     * @param string $measureUnit
     */
    public function __construct($index = null, $fromValue = null, $toValue = null, $measureUnit = null)
    {
        $this
            ->setIndex($index)
            ->setFromValue($fromValue)
            ->setToValue($toValue)
            ->setMeasureUnit($measureUnit);
    }
    /**
     * Get Index value
     * @return int
     */
    public function getIndex()
    {
        return $this->Index;
    }
    /**
     * Set Index value
     * @param int $index
     * @return \dgsoft\StructType\DgRadiusItem
     */
    public function setIndex($index = null)
    {
        // validation for constraint: int
        if (!is_null($index) && !is_numeric($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($index)), __LINE__);
        }
        $this->Index = $index;
        return $this;
    }
    /**
     * Get FromValue value
     * @return int
     */
    public function getFromValue()
    {
        return $this->FromValue;
    }
    /**
     * Set FromValue value
     * @param int $fromValue
     * @return \dgsoft\StructType\DgRadiusItem
     */
    public function setFromValue($fromValue = null)
    {
        // validation for constraint: int
        if (!is_null($fromValue) && !is_numeric($fromValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fromValue)), __LINE__);
        }
        $this->FromValue = $fromValue;
        return $this;
    }
    /**
     * Get ToValue value
     * @return int
     */
    public function getToValue()
    {
        return $this->ToValue;
    }
    /**
     * Set ToValue value
     * @param int $toValue
     * @return \dgsoft\StructType\DgRadiusItem
     */
    public function setToValue($toValue = null)
    {
        // validation for constraint: int
        if (!is_null($toValue) && !is_numeric($toValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($toValue)), __LINE__);
        }
        $this->ToValue = $toValue;
        return $this;
    }
    /**
     * Get MeasureUnit value
     * @return string|null
     */
    public function getMeasureUnit()
    {
        return $this->MeasureUnit;
    }
    /**
     * Set MeasureUnit value
     * @param string $measureUnit
     * @return \dgsoft\StructType\DgRadiusItem
     */
    public function setMeasureUnit($measureUnit = null)
    {
        // validation for constraint: string
        if (!is_null($measureUnit) && !is_string($measureUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($measureUnit)), __LINE__);
        }
        $this->MeasureUnit = $measureUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRadiusItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
