<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Radius StructType
 * @package Dg
 * @subpackage Structs
 */
class DgRadius extends AbstractStructBase
{
    /**
     * The Distance
     * @var string
     */
    public $Distance;
    /**
     * The DistanceMeasure
     * @var string
     */
    public $DistanceMeasure;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The DistanceMax
     * @var string
     */
    public $DistanceMax;
    /**
     * The UnitOfMeasureCode
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * Constructor method for Radius
     * @uses DgRadius::setDistance()
     * @uses DgRadius::setDistanceMeasure()
     * @uses DgRadius::setDirection()
     * @uses DgRadius::setDistanceMax()
     * @uses DgRadius::setUnitOfMeasureCode()
     * @param string $distance
     * @param string $distanceMeasure
     * @param string $direction
     * @param string $distanceMax
     * @param string $unitOfMeasureCode
     */
    public function __construct($distance = null, $distanceMeasure = null, $direction = null, $distanceMax = null, $unitOfMeasureCode = null)
    {
        $this
            ->setDistance($distance)
            ->setDistanceMeasure($distanceMeasure)
            ->setDirection($direction)
            ->setDistanceMax($distanceMax)
            ->setUnitOfMeasureCode($unitOfMeasureCode);
    }
    /**
     * Get Distance value
     * @return string|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param string $distance
     * @return \dgsoft\StructType\DgRadius
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: string
        if (!is_null($distance) && !is_string($distance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DistanceMeasure value
     * @return string|null
     */
    public function getDistanceMeasure()
    {
        return $this->DistanceMeasure;
    }
    /**
     * Set DistanceMeasure value
     * @param string $distanceMeasure
     * @return \dgsoft\StructType\DgRadius
     */
    public function setDistanceMeasure($distanceMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($distanceMeasure) && !is_string($distanceMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceMeasure)), __LINE__);
        }
        $this->DistanceMeasure = $distanceMeasure;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \dgsoft\StructType\DgRadius
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get DistanceMax value
     * @return string|null
     */
    public function getDistanceMax()
    {
        return $this->DistanceMax;
    }
    /**
     * Set DistanceMax value
     * @param string $distanceMax
     * @return \dgsoft\StructType\DgRadius
     */
    public function setDistanceMax($distanceMax = null)
    {
        // validation for constraint: string
        if (!is_null($distanceMax) && !is_string($distanceMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distanceMax)), __LINE__);
        }
        $this->DistanceMax = $distanceMax;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \dgsoft\StructType\DgRadius
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasureCode)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgRadius
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
