<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueueRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgQueueRQ extends AbstractStructBase
{
    /**
     * The QueueNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QueueNumber;
    /**
     * The CategoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryNumber;
    /**
     * The PNRNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PNRNo;
    /**
     * The OfficeId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfficeId;
    /**
     * Constructor method for QueueRQ
     * @uses DgQueueRQ::setQueueNumber()
     * @uses DgQueueRQ::setCategoryNumber()
     * @uses DgQueueRQ::setPNRNo()
     * @uses DgQueueRQ::setOfficeId()
     * @param string $queueNumber
     * @param string $categoryNumber
     * @param string $pNRNo
     * @param string $officeId
     */
    public function __construct($queueNumber = null, $categoryNumber = null, $pNRNo = null, $officeId = null)
    {
        $this
            ->setQueueNumber($queueNumber)
            ->setCategoryNumber($categoryNumber)
            ->setPNRNo($pNRNo)
            ->setOfficeId($officeId);
    }
    /**
     * Get QueueNumber value
     * @return string|null
     */
    public function getQueueNumber()
    {
        return $this->QueueNumber;
    }
    /**
     * Set QueueNumber value
     * @param string $queueNumber
     * @return \dgsoft\StructType\DgQueueRQ
     */
    public function setQueueNumber($queueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($queueNumber) && !is_string($queueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueNumber)), __LINE__);
        }
        $this->QueueNumber = $queueNumber;
        return $this;
    }
    /**
     * Get CategoryNumber value
     * @return string|null
     */
    public function getCategoryNumber()
    {
        return $this->CategoryNumber;
    }
    /**
     * Set CategoryNumber value
     * @param string $categoryNumber
     * @return \dgsoft\StructType\DgQueueRQ
     */
    public function setCategoryNumber($categoryNumber = null)
    {
        // validation for constraint: string
        if (!is_null($categoryNumber) && !is_string($categoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($categoryNumber)), __LINE__);
        }
        $this->CategoryNumber = $categoryNumber;
        return $this;
    }
    /**
     * Get PNRNo value
     * @return string|null
     */
    public function getPNRNo()
    {
        return $this->PNRNo;
    }
    /**
     * Set PNRNo value
     * @param string $pNRNo
     * @return \dgsoft\StructType\DgQueueRQ
     */
    public function setPNRNo($pNRNo = null)
    {
        // validation for constraint: string
        if (!is_null($pNRNo) && !is_string($pNRNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pNRNo)), __LINE__);
        }
        $this->PNRNo = $pNRNo;
        return $this;
    }
    /**
     * Get OfficeId value
     * @return string|null
     */
    public function getOfficeId()
    {
        return $this->OfficeId;
    }
    /**
     * Set OfficeId value
     * @param string $officeId
     * @return \dgsoft\StructType\DgQueueRQ
     */
    public function setOfficeId($officeId = null)
    {
        // validation for constraint: string
        if (!is_null($officeId) && !is_string($officeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($officeId)), __LINE__);
        }
        $this->OfficeId = $officeId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgQueueRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
