<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Queue StructType
 * @package Dg
 * @subpackage Structs
 */
class DgQueue extends AbstractStructBase
{
    /**
     * The PseudoCityCode
     * @var string
     */
    public $PseudoCityCode;
    /**
     * The QueueNumber
     * @var string
     */
    public $QueueNumber;
    /**
     * The QueueCategory
     * @var string
     */
    public $QueueCategory;
    /**
     * The SystemCode
     * @var string
     */
    public $SystemCode;
    /**
     * The QueueID
     * @var string
     */
    public $QueueID;
    /**
     * The DateTime
     * @var string
     */
    public $DateTime;
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * The CarrierCode
     * @var string
     */
    public $CarrierCode;
    /**
     * The QueueRQ
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueueRQ
     */
    public $QueueRQ;
    /**
     * Constructor method for Queue
     * @uses DgQueue::setPseudoCityCode()
     * @uses DgQueue::setQueueNumber()
     * @uses DgQueue::setQueueCategory()
     * @uses DgQueue::setSystemCode()
     * @uses DgQueue::setQueueID()
     * @uses DgQueue::setDateTime()
     * @uses DgQueue::setText()
     * @uses DgQueue::setCarrierCode()
     * @uses DgQueue::setQueueRQ()
     * @param string $pseudoCityCode
     * @param string $queueNumber
     * @param string $queueCategory
     * @param string $systemCode
     * @param string $queueID
     * @param string $dateTime
     * @param string $text
     * @param string $carrierCode
     * @param \dgsoft\StructType\DgQueueRQ $queueRQ
     */
    public function __construct($pseudoCityCode = null, $queueNumber = null, $queueCategory = null, $systemCode = null, $queueID = null, $dateTime = null, $text = null, $carrierCode = null, \dgsoft\StructType\DgQueueRQ $queueRQ = null)
    {
        $this
            ->setPseudoCityCode($pseudoCityCode)
            ->setQueueNumber($queueNumber)
            ->setQueueCategory($queueCategory)
            ->setSystemCode($systemCode)
            ->setQueueID($queueID)
            ->setDateTime($dateTime)
            ->setText($text)
            ->setCarrierCode($carrierCode)
            ->setQueueRQ($queueRQ);
    }
    /**
     * Get PseudoCityCode value
     * @return string|null
     */
    public function getPseudoCityCode()
    {
        return $this->PseudoCityCode;
    }
    /**
     * Set PseudoCityCode value
     * @param string $pseudoCityCode
     * @return \dgsoft\StructType\DgQueue
     */
    public function setPseudoCityCode($pseudoCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($pseudoCityCode) && !is_string($pseudoCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pseudoCityCode)), __LINE__);
        }
        $this->PseudoCityCode = $pseudoCityCode;
        return $this;
    }
    /**
     * Get QueueNumber value
     * @return string|null
     */
    public function getQueueNumber()
    {
        return $this->QueueNumber;
    }
    /**
     * Set QueueNumber value
     * @param string $queueNumber
     * @return \dgsoft\StructType\DgQueue
     */
    public function setQueueNumber($queueNumber = null)
    {
        // validation for constraint: string
        if (!is_null($queueNumber) && !is_string($queueNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueNumber)), __LINE__);
        }
        $this->QueueNumber = $queueNumber;
        return $this;
    }
    /**
     * Get QueueCategory value
     * @return string|null
     */
    public function getQueueCategory()
    {
        return $this->QueueCategory;
    }
    /**
     * Set QueueCategory value
     * @param string $queueCategory
     * @return \dgsoft\StructType\DgQueue
     */
    public function setQueueCategory($queueCategory = null)
    {
        // validation for constraint: string
        if (!is_null($queueCategory) && !is_string($queueCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueCategory)), __LINE__);
        }
        $this->QueueCategory = $queueCategory;
        return $this;
    }
    /**
     * Get SystemCode value
     * @return string|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * Set SystemCode value
     * @param string $systemCode
     * @return \dgsoft\StructType\DgQueue
     */
    public function setSystemCode($systemCode = null)
    {
        // validation for constraint: string
        if (!is_null($systemCode) && !is_string($systemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemCode)), __LINE__);
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
    /**
     * Get QueueID value
     * @return string|null
     */
    public function getQueueID()
    {
        return $this->QueueID;
    }
    /**
     * Set QueueID value
     * @param string $queueID
     * @return \dgsoft\StructType\DgQueue
     */
    public function setQueueID($queueID = null)
    {
        // validation for constraint: string
        if (!is_null($queueID) && !is_string($queueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueID)), __LINE__);
        }
        $this->QueueID = $queueID;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \dgsoft\StructType\DgQueue
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \dgsoft\StructType\DgQueue
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \dgsoft\StructType\DgQueue
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get QueueRQ value
     * @return \dgsoft\StructType\DgQueueRQ|null
     */
    public function getQueueRQ()
    {
        return $this->QueueRQ;
    }
    /**
     * Set QueueRQ value
     * @param \dgsoft\StructType\DgQueueRQ $queueRQ
     * @return \dgsoft\StructType\DgQueue
     */
    public function setQueueRQ(\dgsoft\StructType\DgQueueRQ $queueRQ = null)
    {
        $this->QueueRQ = $queueRQ;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgQueue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
