<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyValueMatchType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPropertyValueMatchType extends DgBasicPropertyInfoType
{
    /**
     * The SearchValueMatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSearchValueMatch[]
     */
    public $SearchValueMatch;
    /**
     * The Amenities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity
     */
    public $Amenities;
    /**
     * The RateRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRateRange
     */
    public $RateRange;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The SameCountryInd
     * @var bool
     */
    public $SameCountryInd;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The HotelCurrency
     * @var string
     */
    public $HotelCurrency;
    /**
     * Constructor method for PropertyValueMatchType
     * @uses DgPropertyValueMatchType::setSearchValueMatch()
     * @uses DgPropertyValueMatchType::setAmenities()
     * @uses DgPropertyValueMatchType::setRateRange()
     * @uses DgPropertyValueMatchType::setMoreDataEchoToken()
     * @uses DgPropertyValueMatchType::setSameCountryInd()
     * @uses DgPropertyValueMatchType::setAvailabilityStatus()
     * @uses DgPropertyValueMatchType::setHotelCurrency()
     * @param \dgsoft\StructType\DgSearchValueMatch[] $searchValueMatch
     * @param \dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity $amenities
     * @param \dgsoft\StructType\DgRateRange $rateRange
     * @param string $moreDataEchoToken
     * @param bool $sameCountryInd
     * @param string $availabilityStatus
     * @param string $hotelCurrency
     */
    public function __construct(array $searchValueMatch = array(), \dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity $amenities = null, \dgsoft\StructType\DgRateRange $rateRange = null, $moreDataEchoToken = null, $sameCountryInd = null, $availabilityStatus = null, $hotelCurrency = null)
    {
        $this
            ->setSearchValueMatch($searchValueMatch)
            ->setAmenities($amenities)
            ->setRateRange($rateRange)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setSameCountryInd($sameCountryInd)
            ->setAvailabilityStatus($availabilityStatus)
            ->setHotelCurrency($hotelCurrency);
    }
    /**
     * Get SearchValueMatch value
     * @return \dgsoft\StructType\DgSearchValueMatch[]|null
     */
    public function getSearchValueMatch()
    {
        return $this->SearchValueMatch;
    }
    /**
     * Set SearchValueMatch value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSearchValueMatch[] $searchValueMatch
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public function setSearchValueMatch(array $searchValueMatch = array())
    {
        foreach ($searchValueMatch as $propertyValueMatchTypeSearchValueMatchItem) {
            // validation for constraint: itemType
            if (!$propertyValueMatchTypeSearchValueMatchItem instanceof \dgsoft\StructType\DgSearchValueMatch) {
                throw new \InvalidArgumentException(sprintf('The SearchValueMatch property can only contain items of \dgsoft\StructType\DgSearchValueMatch, "%s" given', is_object($propertyValueMatchTypeSearchValueMatchItem) ? get_class($propertyValueMatchTypeSearchValueMatchItem) : gettype($propertyValueMatchTypeSearchValueMatchItem)), __LINE__);
            }
        }
        $this->SearchValueMatch = $searchValueMatch;
        return $this;
    }
    /**
     * Add item to SearchValueMatch value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSearchValueMatch $item
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public function addToSearchValueMatch(\dgsoft\StructType\DgSearchValueMatch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSearchValueMatch) {
            throw new \InvalidArgumentException(sprintf('The SearchValueMatch property can only contain items of \dgsoft\StructType\DgSearchValueMatch, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SearchValueMatch[] = $item;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity $amenities
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public function setAmenities(\dgsoft\ArrayType\DgArrayOfPropertyValueMatchTypeAmenity $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \dgsoft\StructType\DgRateRange|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @param \dgsoft\StructType\DgRateRange $rateRange
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public function setRateRange(\dgsoft\StructType\DgRateRange $rateRange = null)
    {
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get SameCountryInd value
     * @return bool|null
     */
    public function getSameCountryInd()
    {
        return $this->SameCountryInd;
    }
    /**
     * Set SameCountryInd value
     * @param bool $sameCountryInd
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public function setSameCountryInd($sameCountryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameCountryInd) && !is_bool($sameCountryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sameCountryInd)), __LINE__);
        }
        $this->SameCountryInd = $sameCountryInd;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \dgsoft\EnumType\DgRateIndicatorType::valueIsValid()
     * @uses \dgsoft\EnumType\DgRateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $availabilityStatus, implode(', ', \dgsoft\EnumType\DgRateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get HotelCurrency value
     * @return string|null
     */
    public function getHotelCurrency()
    {
        return $this->HotelCurrency;
    }
    /**
     * Set HotelCurrency value
     * @param string $hotelCurrency
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public function setHotelCurrency($hotelCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCurrency) && !is_string($hotelCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCurrency)), __LINE__);
        }
        $this->HotelCurrency = $hotelCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPropertyValueMatchType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
