<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyLocationPrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPropertyLocationPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The PropertyLocationType
     * @var string
     */
    public $PropertyLocationType;
    /**
     * Constructor method for PropertyLocationPrefType
     * @uses DgPropertyLocationPrefType::set_()
     * @uses DgPropertyLocationPrefType::setPreferLevel()
     * @uses DgPropertyLocationPrefType::setPropertyLocationType()
     * @param string $_
     * @param string $preferLevel
     * @param string $propertyLocationType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $propertyLocationType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setPropertyLocationType($propertyLocationType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \dgsoft\StructType\DgPropertyLocationPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgPropertyLocationPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get PropertyLocationType value
     * @return string|null
     */
    public function getPropertyLocationType()
    {
        return $this->PropertyLocationType;
    }
    /**
     * Set PropertyLocationType value
     * @param string $propertyLocationType
     * @return \dgsoft\StructType\DgPropertyLocationPrefType
     */
    public function setPropertyLocationType($propertyLocationType = null)
    {
        // validation for constraint: string
        if (!is_null($propertyLocationType) && !is_string($propertyLocationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyLocationType)), __LINE__);
        }
        $this->PropertyLocationType = $propertyLocationType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPropertyLocationPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
