<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessingInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgProcessingInfo extends AbstractStructBase
{
    /**
     * The TargetSource
     * @var string
     */
    public $TargetSource;
    /**
     * The FlightSvcInfoIndicator
     * @var bool
     */
    public $FlightSvcInfoIndicator;
    /**
     * The DisplayOrder
     * @var string
     */
    public $DisplayOrder;
    /**
     * The ReducedDataIndicator
     * @var bool
     */
    public $ReducedDataIndicator;
    /**
     * The BaseFaresOnlyIndicator
     * @var bool
     */
    public $BaseFaresOnlyIndicator;
    /**
     * The SearchType
     * @var string
     */
    public $SearchType;
    /**
     * The AvailabilityIndicator
     * @var bool
     */
    public $AvailabilityIndicator;
    /**
     * Constructor method for ProcessingInfo
     * @uses DgProcessingInfo::setTargetSource()
     * @uses DgProcessingInfo::setFlightSvcInfoIndicator()
     * @uses DgProcessingInfo::setDisplayOrder()
     * @uses DgProcessingInfo::setReducedDataIndicator()
     * @uses DgProcessingInfo::setBaseFaresOnlyIndicator()
     * @uses DgProcessingInfo::setSearchType()
     * @uses DgProcessingInfo::setAvailabilityIndicator()
     * @param string $targetSource
     * @param bool $flightSvcInfoIndicator
     * @param string $displayOrder
     * @param bool $reducedDataIndicator
     * @param bool $baseFaresOnlyIndicator
     * @param string $searchType
     * @param bool $availabilityIndicator
     */
    public function __construct($targetSource = null, $flightSvcInfoIndicator = null, $displayOrder = null, $reducedDataIndicator = null, $baseFaresOnlyIndicator = null, $searchType = null, $availabilityIndicator = null)
    {
        $this
            ->setTargetSource($targetSource)
            ->setFlightSvcInfoIndicator($flightSvcInfoIndicator)
            ->setDisplayOrder($displayOrder)
            ->setReducedDataIndicator($reducedDataIndicator)
            ->setBaseFaresOnlyIndicator($baseFaresOnlyIndicator)
            ->setSearchType($searchType)
            ->setAvailabilityIndicator($availabilityIndicator);
    }
    /**
     * Get TargetSource value
     * @return string|null
     */
    public function getTargetSource()
    {
        return $this->TargetSource;
    }
    /**
     * Set TargetSource value
     * @param string $targetSource
     * @return \dgsoft\StructType\DgProcessingInfo
     */
    public function setTargetSource($targetSource = null)
    {
        // validation for constraint: string
        if (!is_null($targetSource) && !is_string($targetSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetSource)), __LINE__);
        }
        $this->TargetSource = $targetSource;
        return $this;
    }
    /**
     * Get FlightSvcInfoIndicator value
     * @return bool|null
     */
    public function getFlightSvcInfoIndicator()
    {
        return $this->FlightSvcInfoIndicator;
    }
    /**
     * Set FlightSvcInfoIndicator value
     * @param bool $flightSvcInfoIndicator
     * @return \dgsoft\StructType\DgProcessingInfo
     */
    public function setFlightSvcInfoIndicator($flightSvcInfoIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($flightSvcInfoIndicator) && !is_bool($flightSvcInfoIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($flightSvcInfoIndicator)), __LINE__);
        }
        $this->FlightSvcInfoIndicator = $flightSvcInfoIndicator;
        return $this;
    }
    /**
     * Get DisplayOrder value
     * @return string|null
     */
    public function getDisplayOrder()
    {
        return $this->DisplayOrder;
    }
    /**
     * Set DisplayOrder value
     * @uses \dgsoft\EnumType\DgDisplayOrderType::valueIsValid()
     * @uses \dgsoft\EnumType\DgDisplayOrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $displayOrder
     * @return \dgsoft\StructType\DgProcessingInfo
     */
    public function setDisplayOrder($displayOrder = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgDisplayOrderType::valueIsValid($displayOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $displayOrder, implode(', ', \dgsoft\EnumType\DgDisplayOrderType::getValidValues())), __LINE__);
        }
        $this->DisplayOrder = $displayOrder;
        return $this;
    }
    /**
     * Get ReducedDataIndicator value
     * @return bool|null
     */
    public function getReducedDataIndicator()
    {
        return $this->ReducedDataIndicator;
    }
    /**
     * Set ReducedDataIndicator value
     * @param bool $reducedDataIndicator
     * @return \dgsoft\StructType\DgProcessingInfo
     */
    public function setReducedDataIndicator($reducedDataIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($reducedDataIndicator) && !is_bool($reducedDataIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reducedDataIndicator)), __LINE__);
        }
        $this->ReducedDataIndicator = $reducedDataIndicator;
        return $this;
    }
    /**
     * Get BaseFaresOnlyIndicator value
     * @return bool|null
     */
    public function getBaseFaresOnlyIndicator()
    {
        return $this->BaseFaresOnlyIndicator;
    }
    /**
     * Set BaseFaresOnlyIndicator value
     * @param bool $baseFaresOnlyIndicator
     * @return \dgsoft\StructType\DgProcessingInfo
     */
    public function setBaseFaresOnlyIndicator($baseFaresOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($baseFaresOnlyIndicator) && !is_bool($baseFaresOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($baseFaresOnlyIndicator)), __LINE__);
        }
        $this->BaseFaresOnlyIndicator = $baseFaresOnlyIndicator;
        return $this;
    }
    /**
     * Get SearchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->SearchType;
    }
    /**
     * Set SearchType value
     * @param string $searchType
     * @return \dgsoft\StructType\DgProcessingInfo
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: string
        if (!is_null($searchType) && !is_string($searchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchType)), __LINE__);
        }
        $this->SearchType = $searchType;
        return $this;
    }
    /**
     * Get AvailabilityIndicator value
     * @return bool|null
     */
    public function getAvailabilityIndicator()
    {
        return $this->AvailabilityIndicator;
    }
    /**
     * Set AvailabilityIndicator value
     * @param bool $availabilityIndicator
     * @return \dgsoft\StructType\DgProcessingInfo
     */
    public function setAvailabilityIndicator($availabilityIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availabilityIndicator) && !is_bool($availabilityIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availabilityIndicator)), __LINE__);
        }
        $this->AvailabilityIndicator = $availabilityIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgProcessingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
