<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceRequestInformationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPriceRequestInformationType extends AbstractStructBase
{
    /**
     * The NegotiatedFareCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgNegotiatedFareCode[]
     */
    public $NegotiatedFareCode;
    /**
     * The RebookOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRebookOption[]
     */
    public $RebookOption;
    /**
     * The FareQualifier
     * @var string
     */
    public $FareQualifier;
    /**
     * The NegotiatedFaresOnly
     * @var bool
     */
    public $NegotiatedFaresOnly;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PricingSource
     * @var string
     */
    public $PricingSource;
    /**
     * The Reprice
     * @var bool
     */
    public $Reprice;
    /**
     * The CabinType
     * @var string
     */
    public $CabinType;
    /**
     * The TicketingCountry
     * @var string
     */
    public $TicketingCountry;
    /**
     * Constructor method for PriceRequestInformationType
     * @uses DgPriceRequestInformationType::setNegotiatedFareCode()
     * @uses DgPriceRequestInformationType::setRebookOption()
     * @uses DgPriceRequestInformationType::setFareQualifier()
     * @uses DgPriceRequestInformationType::setNegotiatedFaresOnly()
     * @uses DgPriceRequestInformationType::setCurrencyCode()
     * @uses DgPriceRequestInformationType::setPricingSource()
     * @uses DgPriceRequestInformationType::setReprice()
     * @uses DgPriceRequestInformationType::setCabinType()
     * @uses DgPriceRequestInformationType::setTicketingCountry()
     * @param \dgsoft\StructType\DgNegotiatedFareCode[] $negotiatedFareCode
     * @param \dgsoft\StructType\DgRebookOption[] $rebookOption
     * @param string $fareQualifier
     * @param bool $negotiatedFaresOnly
     * @param string $currencyCode
     * @param string $pricingSource
     * @param bool $reprice
     * @param string $cabinType
     * @param string $ticketingCountry
     */
    public function __construct(array $negotiatedFareCode = array(), array $rebookOption = array(), $fareQualifier = null, $negotiatedFaresOnly = null, $currencyCode = null, $pricingSource = null, $reprice = null, $cabinType = null, $ticketingCountry = null)
    {
        $this
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->setRebookOption($rebookOption)
            ->setFareQualifier($fareQualifier)
            ->setNegotiatedFaresOnly($negotiatedFaresOnly)
            ->setCurrencyCode($currencyCode)
            ->setPricingSource($pricingSource)
            ->setReprice($reprice)
            ->setCabinType($cabinType)
            ->setTicketingCountry($ticketingCountry);
    }
    /**
     * Get NegotiatedFareCode value
     * @return \dgsoft\StructType\DgNegotiatedFareCode[]|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgNegotiatedFareCode[] $negotiatedFareCode
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setNegotiatedFareCode(array $negotiatedFareCode = array())
    {
        foreach ($negotiatedFareCode as $priceRequestInformationTypeNegotiatedFareCodeItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationTypeNegotiatedFareCodeItem instanceof \dgsoft\StructType\DgNegotiatedFareCode) {
                throw new \InvalidArgumentException(sprintf('The NegotiatedFareCode property can only contain items of \dgsoft\StructType\DgNegotiatedFareCode, "%s" given', is_object($priceRequestInformationTypeNegotiatedFareCodeItem) ? get_class($priceRequestInformationTypeNegotiatedFareCodeItem) : gettype($priceRequestInformationTypeNegotiatedFareCodeItem)), __LINE__);
            }
        }
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Add item to NegotiatedFareCode value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgNegotiatedFareCode $item
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function addToNegotiatedFareCode(\dgsoft\StructType\DgNegotiatedFareCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgNegotiatedFareCode) {
            throw new \InvalidArgumentException(sprintf('The NegotiatedFareCode property can only contain items of \dgsoft\StructType\DgNegotiatedFareCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NegotiatedFareCode[] = $item;
        return $this;
    }
    /**
     * Get RebookOption value
     * @return \dgsoft\StructType\DgRebookOption[]|null
     */
    public function getRebookOption()
    {
        return $this->RebookOption;
    }
    /**
     * Set RebookOption value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRebookOption[] $rebookOption
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setRebookOption(array $rebookOption = array())
    {
        foreach ($rebookOption as $priceRequestInformationTypeRebookOptionItem) {
            // validation for constraint: itemType
            if (!$priceRequestInformationTypeRebookOptionItem instanceof \dgsoft\StructType\DgRebookOption) {
                throw new \InvalidArgumentException(sprintf('The RebookOption property can only contain items of \dgsoft\StructType\DgRebookOption, "%s" given', is_object($priceRequestInformationTypeRebookOptionItem) ? get_class($priceRequestInformationTypeRebookOptionItem) : gettype($priceRequestInformationTypeRebookOptionItem)), __LINE__);
            }
        }
        $this->RebookOption = $rebookOption;
        return $this;
    }
    /**
     * Add item to RebookOption value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRebookOption $item
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function addToRebookOption(\dgsoft\StructType\DgRebookOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRebookOption) {
            throw new \InvalidArgumentException(sprintf('The RebookOption property can only contain items of \dgsoft\StructType\DgRebookOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RebookOption[] = $item;
        return $this;
    }
    /**
     * Get FareQualifier value
     * @return string|null
     */
    public function getFareQualifier()
    {
        return $this->FareQualifier;
    }
    /**
     * Set FareQualifier value
     * @param string $fareQualifier
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setFareQualifier($fareQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($fareQualifier) && !is_string($fareQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareQualifier)), __LINE__);
        }
        $this->FareQualifier = $fareQualifier;
        return $this;
    }
    /**
     * Get NegotiatedFaresOnly value
     * @return bool|null
     */
    public function getNegotiatedFaresOnly()
    {
        return $this->NegotiatedFaresOnly;
    }
    /**
     * Set NegotiatedFaresOnly value
     * @param bool $negotiatedFaresOnly
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setNegotiatedFaresOnly($negotiatedFaresOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($negotiatedFaresOnly) && !is_bool($negotiatedFaresOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($negotiatedFaresOnly)), __LINE__);
        }
        $this->NegotiatedFaresOnly = $negotiatedFaresOnly;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @uses \dgsoft\EnumType\DgPricingSourceType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPricingSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingSource
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setPricingSource($pricingSource = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPricingSourceType::valueIsValid($pricingSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pricingSource, implode(', ', \dgsoft\EnumType\DgPricingSourceType::getValidValues())), __LINE__);
        }
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get Reprice value
     * @return bool|null
     */
    public function getReprice()
    {
        return $this->Reprice;
    }
    /**
     * Set Reprice value
     * @param bool $reprice
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setReprice($reprice = null)
    {
        // validation for constraint: boolean
        if (!is_null($reprice) && !is_bool($reprice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($reprice)), __LINE__);
        }
        $this->Reprice = $reprice;
        return $this;
    }
    /**
     * Get CabinType value
     * @return string|null
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \dgsoft\EnumType\DgCabinType::valueIsValid()
     * @uses \dgsoft\EnumType\DgCabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgCabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cabinType, implode(', ', \dgsoft\EnumType\DgCabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get TicketingCountry value
     * @return string|null
     */
    public function getTicketingCountry()
    {
        return $this->TicketingCountry;
    }
    /**
     * Set TicketingCountry value
     * @param string $ticketingCountry
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public function setTicketingCountry($ticketingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingCountry) && !is_string($ticketingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketingCountry)), __LINE__);
        }
        $this->TicketingCountry = $ticketingCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPriceRequestInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
