<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanCostTypeBasePremium StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPlanCostTypeBasePremium extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The MarkupAmount
     * @var float
     */
    public $MarkupAmount;
    /**
     * Constructor method for PlanCostTypeBasePremium
     * @uses DgPlanCostTypeBasePremium::setCurrencyCode()
     * @uses DgPlanCostTypeBasePremium::setAmount()
     * @uses DgPlanCostTypeBasePremium::setMarkupAmount()
     * @param string $currencyCode
     * @param float $amount
     * @param float $markupAmount
     */
    public function __construct($currencyCode = null, $amount = null, $markupAmount = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount)
            ->setMarkupAmount($markupAmount);
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgPlanCostTypeBasePremium
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgPlanCostTypeBasePremium
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get MarkupAmount value
     * @return float|null
     */
    public function getMarkupAmount()
    {
        return $this->MarkupAmount;
    }
    /**
     * Set MarkupAmount value
     * @param float $markupAmount
     * @return \dgsoft\StructType\DgPlanCostTypeBasePremium
     */
    public function setMarkupAmount($markupAmount = null)
    {
        $this->MarkupAmount = $markupAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPlanCostTypeBasePremium
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
