<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlanCostType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPlanCostType extends AbstractStructBase
{
    /**
     * The BasePremium
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPlanCostTypeBasePremium
     */
    public $BasePremium;
    /**
     * The Charges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFeeType1
     */
    public $Charges;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The MarkupAmount
     * @var float
     */
    public $MarkupAmount;
    /**
     * Constructor method for PlanCostType
     * @uses DgPlanCostType::setBasePremium()
     * @uses DgPlanCostType::setCharges()
     * @uses DgPlanCostType::setCurrencyCode()
     * @uses DgPlanCostType::setAmount()
     * @uses DgPlanCostType::setMarkupAmount()
     * @param \dgsoft\StructType\DgPlanCostTypeBasePremium $basePremium
     * @param \dgsoft\ArrayType\DgArrayOfFeeType1 $charges
     * @param string $currencyCode
     * @param float $amount
     * @param float $markupAmount
     */
    public function __construct(\dgsoft\StructType\DgPlanCostTypeBasePremium $basePremium = null, \dgsoft\ArrayType\DgArrayOfFeeType1 $charges = null, $currencyCode = null, $amount = null, $markupAmount = null)
    {
        $this
            ->setBasePremium($basePremium)
            ->setCharges($charges)
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount)
            ->setMarkupAmount($markupAmount);
    }
    /**
     * Get BasePremium value
     * @return \dgsoft\StructType\DgPlanCostTypeBasePremium|null
     */
    public function getBasePremium()
    {
        return $this->BasePremium;
    }
    /**
     * Set BasePremium value
     * @param \dgsoft\StructType\DgPlanCostTypeBasePremium $basePremium
     * @return \dgsoft\StructType\DgPlanCostType
     */
    public function setBasePremium(\dgsoft\StructType\DgPlanCostTypeBasePremium $basePremium = null)
    {
        $this->BasePremium = $basePremium;
        return $this;
    }
    /**
     * Get Charges value
     * @return \dgsoft\ArrayType\DgArrayOfFeeType1|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \dgsoft\ArrayType\DgArrayOfFeeType1 $charges
     * @return \dgsoft\StructType\DgPlanCostType
     */
    public function setCharges(\dgsoft\ArrayType\DgArrayOfFeeType1 $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgPlanCostType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgPlanCostType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get MarkupAmount value
     * @return float|null
     */
    public function getMarkupAmount()
    {
        return $this->MarkupAmount;
    }
    /**
     * Set MarkupAmount value
     * @param float $markupAmount
     * @return \dgsoft\StructType\DgPlanCostType
     */
    public function setMarkupAmount($markupAmount = null)
    {
        $this->MarkupAmount = $markupAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPlanCostType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
