<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRulesType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPaymentRulesType extends AbstractStructBase
{
    /**
     * The PaymentRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMonetaryRuleType[]
     */
    public $PaymentRule;
    /**
     * Constructor method for PaymentRulesType
     * @uses DgPaymentRulesType::setPaymentRule()
     * @param \dgsoft\StructType\DgMonetaryRuleType[] $paymentRule
     */
    public function __construct(array $paymentRule = array())
    {
        $this
            ->setPaymentRule($paymentRule);
    }
    /**
     * Get PaymentRule value
     * @return \dgsoft\StructType\DgMonetaryRuleType[]|null
     */
    public function getPaymentRule()
    {
        return $this->PaymentRule;
    }
    /**
     * Set PaymentRule value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMonetaryRuleType[] $paymentRule
     * @return \dgsoft\StructType\DgPaymentRulesType
     */
    public function setPaymentRule(array $paymentRule = array())
    {
        foreach ($paymentRule as $paymentRulesTypePaymentRuleItem) {
            // validation for constraint: itemType
            if (!$paymentRulesTypePaymentRuleItem instanceof \dgsoft\StructType\DgMonetaryRuleType) {
                throw new \InvalidArgumentException(sprintf('The PaymentRule property can only contain items of \dgsoft\StructType\DgMonetaryRuleType, "%s" given', is_object($paymentRulesTypePaymentRuleItem) ? get_class($paymentRulesTypePaymentRuleItem) : gettype($paymentRulesTypePaymentRuleItem)), __LINE__);
            }
        }
        $this->PaymentRule = $paymentRule;
        return $this;
    }
    /**
     * Add item to PaymentRule value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMonetaryRuleType $item
     * @return \dgsoft\StructType\DgPaymentRulesType
     */
    public function addToPaymentRule(\dgsoft\StructType\DgMonetaryRuleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMonetaryRuleType) {
            throw new \InvalidArgumentException(sprintf('The PaymentRule property can only contain items of \dgsoft\StructType\DgMonetaryRuleType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPaymentRulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
