<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFormType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPaymentFormType extends AbstractStructBase
{
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PaymentType;
    /**
     * The PaymentFPType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PaymentFPType;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressType
     */
    public $BillingAddress;
    /**
     * The BankAcct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBankAcctType
     */
    public $BankAcct;
    /**
     * The LoyaltyRedemption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLoyaltyRedemption
     */
    public $LoyaltyRedemption;
    /**
     * The Voucher
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVoucher
     */
    public $Voucher;
    /**
     * The DirectBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDirectBillType
     */
    public $DirectBill;
    /**
     * The MiscChargeOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMiscChargeOrder
     */
    public $MiscChargeOrder;
    /**
     * The Cash
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCash
     */
    public $Cash;
    /**
     * The PaymentCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentCardType
     */
    public $PaymentCard;
    /**
     * The TFThreeDSecureResultURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TFThreeDSecureResultURL;
    /**
     * The ThreeDSecureReturnURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ThreeDSecureReturnURL;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The CostCenterID
     * @var string
     */
    public $CostCenterID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The PaymentTransactionTypeCode
     * @var string
     */
    public $PaymentTransactionTypeCode;
    /**
     * Constructor method for PaymentFormType
     * @uses DgPaymentFormType::setPaymentType()
     * @uses DgPaymentFormType::setPaymentFPType()
     * @uses DgPaymentFormType::setBillingAddress()
     * @uses DgPaymentFormType::setBankAcct()
     * @uses DgPaymentFormType::setLoyaltyRedemption()
     * @uses DgPaymentFormType::setVoucher()
     * @uses DgPaymentFormType::setDirectBill()
     * @uses DgPaymentFormType::setMiscChargeOrder()
     * @uses DgPaymentFormType::setCash()
     * @uses DgPaymentFormType::setPaymentCard()
     * @uses DgPaymentFormType::setTFThreeDSecureResultURL()
     * @uses DgPaymentFormType::setThreeDSecureReturnURL()
     * @uses DgPaymentFormType::setShareSynchInd()
     * @uses DgPaymentFormType::setShareMarketInd()
     * @uses DgPaymentFormType::setCostCenterID()
     * @uses DgPaymentFormType::setRPH()
     * @uses DgPaymentFormType::setPaymentTransactionTypeCode()
     * @param string $paymentType
     * @param string $paymentFPType
     * @param \dgsoft\StructType\DgAddressType $billingAddress
     * @param \dgsoft\StructType\DgBankAcctType $bankAcct
     * @param \dgsoft\StructType\DgLoyaltyRedemption $loyaltyRedemption
     * @param \dgsoft\StructType\DgVoucher $voucher
     * @param \dgsoft\StructType\DgDirectBillType $directBill
     * @param \dgsoft\StructType\DgMiscChargeOrder $miscChargeOrder
     * @param \dgsoft\StructType\DgCash $cash
     * @param \dgsoft\StructType\DgPaymentCardType $paymentCard
     * @param string $tFThreeDSecureResultURL
     * @param string $threeDSecureReturnURL
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $costCenterID
     * @param string $rPH
     * @param string $paymentTransactionTypeCode
     */
    public function __construct($paymentType = null, $paymentFPType = null, \dgsoft\StructType\DgAddressType $billingAddress = null, \dgsoft\StructType\DgBankAcctType $bankAcct = null, \dgsoft\StructType\DgLoyaltyRedemption $loyaltyRedemption = null, \dgsoft\StructType\DgVoucher $voucher = null, \dgsoft\StructType\DgDirectBillType $directBill = null, \dgsoft\StructType\DgMiscChargeOrder $miscChargeOrder = null, \dgsoft\StructType\DgCash $cash = null, \dgsoft\StructType\DgPaymentCardType $paymentCard = null, $tFThreeDSecureResultURL = null, $threeDSecureReturnURL = null, $shareSynchInd = null, $shareMarketInd = null, $costCenterID = null, $rPH = null, $paymentTransactionTypeCode = null)
    {
        $this
            ->setPaymentType($paymentType)
            ->setPaymentFPType($paymentFPType)
            ->setBillingAddress($billingAddress)
            ->setBankAcct($bankAcct)
            ->setLoyaltyRedemption($loyaltyRedemption)
            ->setVoucher($voucher)
            ->setDirectBill($directBill)
            ->setMiscChargeOrder($miscChargeOrder)
            ->setCash($cash)
            ->setPaymentCard($paymentCard)
            ->setTFThreeDSecureResultURL($tFThreeDSecureResultURL)
            ->setThreeDSecureReturnURL($threeDSecureReturnURL)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setCostCenterID($costCenterID)
            ->setRPH($rPH)
            ->setPaymentTransactionTypeCode($paymentTransactionTypeCode);
    }
    /**
     * Get PaymentType value
     * @return string
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @uses \dgsoft\EnumType\DgPaymentTypes::valueIsValid()
     * @uses \dgsoft\EnumType\DgPaymentTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentType
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPaymentTypes::valueIsValid($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentType, implode(', ', \dgsoft\EnumType\DgPaymentTypes::getValidValues())), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get PaymentFPType value
     * @return string
     */
    public function getPaymentFPType()
    {
        return $this->PaymentFPType;
    }
    /**
     * Set PaymentFPType value
     * @uses \dgsoft\EnumType\DgPaymentFPTypes::valueIsValid()
     * @uses \dgsoft\EnumType\DgPaymentFPTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentFPType
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setPaymentFPType($paymentFPType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPaymentFPTypes::valueIsValid($paymentFPType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentFPType, implode(', ', \dgsoft\EnumType\DgPaymentFPTypes::getValidValues())), __LINE__);
        }
        $this->PaymentFPType = $paymentFPType;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \dgsoft\StructType\DgAddressType|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \dgsoft\StructType\DgAddressType $billingAddress
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setBillingAddress(\dgsoft\StructType\DgAddressType $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get BankAcct value
     * @return \dgsoft\StructType\DgBankAcctType|null
     */
    public function getBankAcct()
    {
        return $this->BankAcct;
    }
    /**
     * Set BankAcct value
     * @param \dgsoft\StructType\DgBankAcctType $bankAcct
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setBankAcct(\dgsoft\StructType\DgBankAcctType $bankAcct = null)
    {
        $this->BankAcct = $bankAcct;
        return $this;
    }
    /**
     * Get LoyaltyRedemption value
     * @return \dgsoft\StructType\DgLoyaltyRedemption|null
     */
    public function getLoyaltyRedemption()
    {
        return $this->LoyaltyRedemption;
    }
    /**
     * Set LoyaltyRedemption value
     * @param \dgsoft\StructType\DgLoyaltyRedemption $loyaltyRedemption
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setLoyaltyRedemption(\dgsoft\StructType\DgLoyaltyRedemption $loyaltyRedemption = null)
    {
        $this->LoyaltyRedemption = $loyaltyRedemption;
        return $this;
    }
    /**
     * Get Voucher value
     * @return \dgsoft\StructType\DgVoucher|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param \dgsoft\StructType\DgVoucher $voucher
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setVoucher(\dgsoft\StructType\DgVoucher $voucher = null)
    {
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get DirectBill value
     * @return \dgsoft\StructType\DgDirectBillType|null
     */
    public function getDirectBill()
    {
        return $this->DirectBill;
    }
    /**
     * Set DirectBill value
     * @param \dgsoft\StructType\DgDirectBillType $directBill
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setDirectBill(\dgsoft\StructType\DgDirectBillType $directBill = null)
    {
        $this->DirectBill = $directBill;
        return $this;
    }
    /**
     * Get MiscChargeOrder value
     * @return \dgsoft\StructType\DgMiscChargeOrder|null
     */
    public function getMiscChargeOrder()
    {
        return $this->MiscChargeOrder;
    }
    /**
     * Set MiscChargeOrder value
     * @param \dgsoft\StructType\DgMiscChargeOrder $miscChargeOrder
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setMiscChargeOrder(\dgsoft\StructType\DgMiscChargeOrder $miscChargeOrder = null)
    {
        $this->MiscChargeOrder = $miscChargeOrder;
        return $this;
    }
    /**
     * Get Cash value
     * @return \dgsoft\StructType\DgCash|null
     */
    public function getCash()
    {
        return $this->Cash;
    }
    /**
     * Set Cash value
     * @param \dgsoft\StructType\DgCash $cash
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setCash(\dgsoft\StructType\DgCash $cash = null)
    {
        $this->Cash = $cash;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \dgsoft\StructType\DgPaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \dgsoft\StructType\DgPaymentCardType $paymentCard
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setPaymentCard(\dgsoft\StructType\DgPaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get TFThreeDSecureResultURL value
     * @return string|null
     */
    public function getTFThreeDSecureResultURL()
    {
        return $this->TFThreeDSecureResultURL;
    }
    /**
     * Set TFThreeDSecureResultURL value
     * @param string $tFThreeDSecureResultURL
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setTFThreeDSecureResultURL($tFThreeDSecureResultURL = null)
    {
        // validation for constraint: string
        if (!is_null($tFThreeDSecureResultURL) && !is_string($tFThreeDSecureResultURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tFThreeDSecureResultURL)), __LINE__);
        }
        $this->TFThreeDSecureResultURL = $tFThreeDSecureResultURL;
        return $this;
    }
    /**
     * Get ThreeDSecureReturnURL value
     * @return string|null
     */
    public function getThreeDSecureReturnURL()
    {
        return $this->ThreeDSecureReturnURL;
    }
    /**
     * Set ThreeDSecureReturnURL value
     * @param string $threeDSecureReturnURL
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setThreeDSecureReturnURL($threeDSecureReturnURL = null)
    {
        // validation for constraint: string
        if (!is_null($threeDSecureReturnURL) && !is_string($threeDSecureReturnURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($threeDSecureReturnURL)), __LINE__);
        }
        $this->ThreeDSecureReturnURL = $threeDSecureReturnURL;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get CostCenterID value
     * @return string|null
     */
    public function getCostCenterID()
    {
        return $this->CostCenterID;
    }
    /**
     * Set CostCenterID value
     * @param string $costCenterID
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setCostCenterID($costCenterID = null)
    {
        // validation for constraint: string
        if (!is_null($costCenterID) && !is_string($costCenterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costCenterID)), __LINE__);
        }
        $this->CostCenterID = $costCenterID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get PaymentTransactionTypeCode value
     * @return string|null
     */
    public function getPaymentTransactionTypeCode()
    {
        return $this->PaymentTransactionTypeCode;
    }
    /**
     * Set PaymentTransactionTypeCode value
     * @param string $paymentTransactionTypeCode
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public function setPaymentTransactionTypeCode($paymentTransactionTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTransactionTypeCode) && !is_string($paymentTransactionTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTransactionTypeCode)), __LINE__);
        }
        $this->PaymentTransactionTypeCode = $paymentTransactionTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPaymentFormType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
