<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPassengerInfo extends AbstractStructBase
{
    /**
     * The PassengerIndex
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PassengerIndex;
    /**
     * The FrequentFlyerCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFrequentFlyerCardType[]
     */
    public $FrequentFlyerCard;
    /**
     * The PassengerType
     * @var string
     */
    public $PassengerType;
    /**
     * Constructor method for PassengerInfo
     * @uses DgPassengerInfo::setPassengerIndex()
     * @uses DgPassengerInfo::setFrequentFlyerCard()
     * @uses DgPassengerInfo::setPassengerType()
     * @param int $passengerIndex
     * @param \dgsoft\StructType\DgFrequentFlyerCardType[] $frequentFlyerCard
     * @param string $passengerType
     */
    public function __construct($passengerIndex = null, array $frequentFlyerCard = array(), $passengerType = null)
    {
        $this
            ->setPassengerIndex($passengerIndex)
            ->setFrequentFlyerCard($frequentFlyerCard)
            ->setPassengerType($passengerType);
    }
    /**
     * Get PassengerIndex value
     * @return int
     */
    public function getPassengerIndex()
    {
        return $this->PassengerIndex;
    }
    /**
     * Set PassengerIndex value
     * @param int $passengerIndex
     * @return \dgsoft\StructType\DgPassengerInfo
     */
    public function setPassengerIndex($passengerIndex = null)
    {
        // validation for constraint: int
        if (!is_null($passengerIndex) && !is_numeric($passengerIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerIndex)), __LINE__);
        }
        $this->PassengerIndex = $passengerIndex;
        return $this;
    }
    /**
     * Get FrequentFlyerCard value
     * @return \dgsoft\StructType\DgFrequentFlyerCardType[]|null
     */
    public function getFrequentFlyerCard()
    {
        return $this->FrequentFlyerCard;
    }
    /**
     * Set FrequentFlyerCard value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFrequentFlyerCardType[] $frequentFlyerCard
     * @return \dgsoft\StructType\DgPassengerInfo
     */
    public function setFrequentFlyerCard(array $frequentFlyerCard = array())
    {
        foreach ($frequentFlyerCard as $passengerInfoFrequentFlyerCardItem) {
            // validation for constraint: itemType
            if (!$passengerInfoFrequentFlyerCardItem instanceof \dgsoft\StructType\DgFrequentFlyerCardType) {
                throw new \InvalidArgumentException(sprintf('The FrequentFlyerCard property can only contain items of \dgsoft\StructType\DgFrequentFlyerCardType, "%s" given', is_object($passengerInfoFrequentFlyerCardItem) ? get_class($passengerInfoFrequentFlyerCardItem) : gettype($passengerInfoFrequentFlyerCardItem)), __LINE__);
            }
        }
        $this->FrequentFlyerCard = $frequentFlyerCard;
        return $this;
    }
    /**
     * Add item to FrequentFlyerCard value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFrequentFlyerCardType $item
     * @return \dgsoft\StructType\DgPassengerInfo
     */
    public function addToFrequentFlyerCard(\dgsoft\StructType\DgFrequentFlyerCardType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFrequentFlyerCardType) {
            throw new \InvalidArgumentException(sprintf('The FrequentFlyerCard property can only contain items of \dgsoft\StructType\DgFrequentFlyerCardType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FrequentFlyerCard[] = $item;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \dgsoft\StructType\DgPassengerInfo
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: string
        if (!is_null($passengerType) && !is_string($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPassengerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
