<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerDB StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPassengerDB extends DgPerson
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $UserID;
    /**
     * The FormOfIdentificationExpirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FormOfIdentificationExpirationDate;
    /**
     * The PassengerDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPassengerDetails
     */
    public $PassengerDetails;
    /**
     * The TypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCode;
    /**
     * The FormOfIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormOfIdentification;
    /**
     * The FormOfIdentificationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormOfIdentificationType;
    /**
     * The FormOfIdentificationCreditCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormOfIdentificationCreditCardType;
    /**
     * The FormOfIdentificationIssueLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormOfIdentificationIssueLocation;
    /**
     * The IdentityNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdentityNo;
    /**
     * Constructor method for PassengerDB
     * @uses DgPassengerDB::setUserID()
     * @uses DgPassengerDB::setFormOfIdentificationExpirationDate()
     * @uses DgPassengerDB::setPassengerDetails()
     * @uses DgPassengerDB::setTypeCode()
     * @uses DgPassengerDB::setFormOfIdentification()
     * @uses DgPassengerDB::setFormOfIdentificationType()
     * @uses DgPassengerDB::setFormOfIdentificationCreditCardType()
     * @uses DgPassengerDB::setFormOfIdentificationIssueLocation()
     * @uses DgPassengerDB::setIdentityNo()
     * @param string $userID
     * @param string $formOfIdentificationExpirationDate
     * @param \dgsoft\StructType\DgPassengerDetails $passengerDetails
     * @param string $typeCode
     * @param string $formOfIdentification
     * @param string $formOfIdentificationType
     * @param string $formOfIdentificationCreditCardType
     * @param string $formOfIdentificationIssueLocation
     * @param string $identityNo
     */
    public function __construct($userID = null, $formOfIdentificationExpirationDate = null, \dgsoft\StructType\DgPassengerDetails $passengerDetails = null, $typeCode = null, $formOfIdentification = null, $formOfIdentificationType = null, $formOfIdentificationCreditCardType = null, $formOfIdentificationIssueLocation = null, $identityNo = null)
    {
        $this
            ->setUserID($userID)
            ->setFormOfIdentificationExpirationDate($formOfIdentificationExpirationDate)
            ->setPassengerDetails($passengerDetails)
            ->setTypeCode($typeCode)
            ->setFormOfIdentification($formOfIdentification)
            ->setFormOfIdentificationType($formOfIdentificationType)
            ->setFormOfIdentificationCreditCardType($formOfIdentificationCreditCardType)
            ->setFormOfIdentificationIssueLocation($formOfIdentificationIssueLocation)
            ->setIdentityNo($identityNo);
    }
    /**
     * Get UserID value
     * @return string
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($userID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($userID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get FormOfIdentificationExpirationDate value
     * @return string
     */
    public function getFormOfIdentificationExpirationDate()
    {
        return $this->FormOfIdentificationExpirationDate;
    }
    /**
     * Set FormOfIdentificationExpirationDate value
     * @param string $formOfIdentificationExpirationDate
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setFormOfIdentificationExpirationDate($formOfIdentificationExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($formOfIdentificationExpirationDate) && !is_string($formOfIdentificationExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formOfIdentificationExpirationDate)), __LINE__);
        }
        $this->FormOfIdentificationExpirationDate = $formOfIdentificationExpirationDate;
        return $this;
    }
    /**
     * Get PassengerDetails value
     * @return \dgsoft\StructType\DgPassengerDetails|null
     */
    public function getPassengerDetails()
    {
        return $this->PassengerDetails;
    }
    /**
     * Set PassengerDetails value
     * @param \dgsoft\StructType\DgPassengerDetails $passengerDetails
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setPassengerDetails(\dgsoft\StructType\DgPassengerDetails $passengerDetails = null)
    {
        $this->PassengerDetails = $passengerDetails;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get FormOfIdentification value
     * @return string|null
     */
    public function getFormOfIdentification()
    {
        return $this->FormOfIdentification;
    }
    /**
     * Set FormOfIdentification value
     * @param string $formOfIdentification
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setFormOfIdentification($formOfIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($formOfIdentification) && !is_string($formOfIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formOfIdentification)), __LINE__);
        }
        $this->FormOfIdentification = $formOfIdentification;
        return $this;
    }
    /**
     * Get FormOfIdentificationType value
     * @return string|null
     */
    public function getFormOfIdentificationType()
    {
        return $this->FormOfIdentificationType;
    }
    /**
     * Set FormOfIdentificationType value
     * @param string $formOfIdentificationType
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setFormOfIdentificationType($formOfIdentificationType = null)
    {
        // validation for constraint: string
        if (!is_null($formOfIdentificationType) && !is_string($formOfIdentificationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formOfIdentificationType)), __LINE__);
        }
        $this->FormOfIdentificationType = $formOfIdentificationType;
        return $this;
    }
    /**
     * Get FormOfIdentificationCreditCardType value
     * @return string|null
     */
    public function getFormOfIdentificationCreditCardType()
    {
        return $this->FormOfIdentificationCreditCardType;
    }
    /**
     * Set FormOfIdentificationCreditCardType value
     * @param string $formOfIdentificationCreditCardType
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setFormOfIdentificationCreditCardType($formOfIdentificationCreditCardType = null)
    {
        // validation for constraint: string
        if (!is_null($formOfIdentificationCreditCardType) && !is_string($formOfIdentificationCreditCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formOfIdentificationCreditCardType)), __LINE__);
        }
        $this->FormOfIdentificationCreditCardType = $formOfIdentificationCreditCardType;
        return $this;
    }
    /**
     * Get FormOfIdentificationIssueLocation value
     * @return string|null
     */
    public function getFormOfIdentificationIssueLocation()
    {
        return $this->FormOfIdentificationIssueLocation;
    }
    /**
     * Set FormOfIdentificationIssueLocation value
     * @param string $formOfIdentificationIssueLocation
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setFormOfIdentificationIssueLocation($formOfIdentificationIssueLocation = null)
    {
        // validation for constraint: string
        if (!is_null($formOfIdentificationIssueLocation) && !is_string($formOfIdentificationIssueLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formOfIdentificationIssueLocation)), __LINE__);
        }
        $this->FormOfIdentificationIssueLocation = $formOfIdentificationIssueLocation;
        return $this;
    }
    /**
     * Get IdentityNo value
     * @return string|null
     */
    public function getIdentityNo()
    {
        return $this->IdentityNo;
    }
    /**
     * Set IdentityNo value
     * @param string $identityNo
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public function setIdentityNo($identityNo = null)
    {
        // validation for constraint: string
        if (!is_null($identityNo) && !is_string($identityNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identityNo)), __LINE__);
        }
        $this->IdentityNo = $identityNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPassengerDB
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
