<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTCFareBreakdownType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPTCFareBreakdownType extends AbstractStructBase
{
    /**
     * The PassengerTypeQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPassengerTypeQuantityType
     */
    public $PassengerTypeQuantity;
    /**
     * The FareBasisCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfString2
     */
    public $FareBasisCodes;
    /**
     * The PassengerFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareType
     */
    public $PassengerFare;
    /**
     * The TravelerRefNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The TicketDesignators
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownTypeTicketDesignator
     */
    public $TicketDesignators;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEndorsements
     */
    public $Endorsements;
    /**
     * The FareInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareInfo[]
     */
    public $FareInfo;
    /**
     * The PricingUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPricingUnit[]
     */
    public $PricingUnit;
    /**
     * The PricingSource
     * @var string
     */
    public $PricingSource;
    /**
     * Constructor method for PTCFareBreakdownType
     * @uses DgPTCFareBreakdownType::setPassengerTypeQuantity()
     * @uses DgPTCFareBreakdownType::setFareBasisCodes()
     * @uses DgPTCFareBreakdownType::setPassengerFare()
     * @uses DgPTCFareBreakdownType::setTravelerRefNumber()
     * @uses DgPTCFareBreakdownType::setTicketDesignators()
     * @uses DgPTCFareBreakdownType::setEndorsements()
     * @uses DgPTCFareBreakdownType::setFareInfo()
     * @uses DgPTCFareBreakdownType::setPricingUnit()
     * @uses DgPTCFareBreakdownType::setPricingSource()
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity
     * @param \dgsoft\ArrayType\DgArrayOfString2 $fareBasisCodes
     * @param \dgsoft\StructType\DgFareType $passengerFare
     * @param \dgsoft\StructType\DgTravelerRefNumber[] $travelerRefNumber
     * @param \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownTypeTicketDesignator $ticketDesignators
     * @param \dgsoft\StructType\DgEndorsements $endorsements
     * @param \dgsoft\StructType\DgFareInfo[] $fareInfo
     * @param \dgsoft\StructType\DgPricingUnit[] $pricingUnit
     * @param string $pricingSource
     */
    public function __construct(\dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity = null, \dgsoft\ArrayType\DgArrayOfString2 $fareBasisCodes = null, \dgsoft\StructType\DgFareType $passengerFare = null, array $travelerRefNumber = array(), \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownTypeTicketDesignator $ticketDesignators = null, \dgsoft\StructType\DgEndorsements $endorsements = null, array $fareInfo = array(), array $pricingUnit = array(), $pricingSource = null)
    {
        $this
            ->setPassengerTypeQuantity($passengerTypeQuantity)
            ->setFareBasisCodes($fareBasisCodes)
            ->setPassengerFare($passengerFare)
            ->setTravelerRefNumber($travelerRefNumber)
            ->setTicketDesignators($ticketDesignators)
            ->setEndorsements($endorsements)
            ->setFareInfo($fareInfo)
            ->setPricingUnit($pricingUnit)
            ->setPricingSource($pricingSource);
    }
    /**
     * Get PassengerTypeQuantity value
     * @return \dgsoft\StructType\DgPassengerTypeQuantityType|null
     */
    public function getPassengerTypeQuantity()
    {
        return $this->PassengerTypeQuantity;
    }
    /**
     * Set PassengerTypeQuantity value
     * @param \dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setPassengerTypeQuantity(\dgsoft\StructType\DgPassengerTypeQuantityType $passengerTypeQuantity = null)
    {
        $this->PassengerTypeQuantity = $passengerTypeQuantity;
        return $this;
    }
    /**
     * Get FareBasisCodes value
     * @return \dgsoft\ArrayType\DgArrayOfString2|null
     */
    public function getFareBasisCodes()
    {
        return $this->FareBasisCodes;
    }
    /**
     * Set FareBasisCodes value
     * @param \dgsoft\ArrayType\DgArrayOfString2 $fareBasisCodes
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setFareBasisCodes(\dgsoft\ArrayType\DgArrayOfString2 $fareBasisCodes = null)
    {
        $this->FareBasisCodes = $fareBasisCodes;
        return $this;
    }
    /**
     * Get PassengerFare value
     * @return \dgsoft\StructType\DgFareType|null
     */
    public function getPassengerFare()
    {
        return $this->PassengerFare;
    }
    /**
     * Set PassengerFare value
     * @param \dgsoft\StructType\DgFareType $passengerFare
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setPassengerFare(\dgsoft\StructType\DgFareType $passengerFare = null)
    {
        $this->PassengerFare = $passengerFare;
        return $this;
    }
    /**
     * Get TravelerRefNumber value
     * @return \dgsoft\StructType\DgTravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelerRefNumber[] $travelerRefNumber
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        foreach ($travelerRefNumber as $pTCFareBreakdownTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypeTravelerRefNumberItem instanceof \dgsoft\StructType\DgTravelerRefNumber) {
                throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of \dgsoft\StructType\DgTravelerRefNumber, "%s" given', is_object($pTCFareBreakdownTypeTravelerRefNumberItem) ? get_class($pTCFareBreakdownTypeTravelerRefNumberItem) : gettype($pTCFareBreakdownTypeTravelerRefNumberItem)), __LINE__);
            }
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelerRefNumber $item
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function addToTravelerRefNumber(\dgsoft\StructType\DgTravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of \dgsoft\StructType\DgTravelerRefNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get TicketDesignators value
     * @return \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownTypeTicketDesignator|null
     */
    public function getTicketDesignators()
    {
        return $this->TicketDesignators;
    }
    /**
     * Set TicketDesignators value
     * @param \dgsoft\ArrayType\DgArrayOfPTCFareBreakdownTypeTicketDesignator $ticketDesignators
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setTicketDesignators(\dgsoft\ArrayType\DgArrayOfPTCFareBreakdownTypeTicketDesignator $ticketDesignators = null)
    {
        $this->TicketDesignators = $ticketDesignators;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \dgsoft\StructType\DgEndorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \dgsoft\StructType\DgEndorsements $endorsements
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setEndorsements(\dgsoft\StructType\DgEndorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \dgsoft\StructType\DgFareInfo[]|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * Set FareInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareInfo[] $fareInfo
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setFareInfo(array $fareInfo = array())
    {
        foreach ($fareInfo as $pTCFareBreakdownTypeFareInfoItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypeFareInfoItem instanceof \dgsoft\StructType\DgFareInfo) {
                throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of \dgsoft\StructType\DgFareInfo, "%s" given', is_object($pTCFareBreakdownTypeFareInfoItem) ? get_class($pTCFareBreakdownTypeFareInfoItem) : gettype($pTCFareBreakdownTypeFareInfoItem)), __LINE__);
            }
        }
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Add item to FareInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareInfo $item
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function addToFareInfo(\dgsoft\StructType\DgFareInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareInfo) {
            throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of \dgsoft\StructType\DgFareInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareInfo[] = $item;
        return $this;
    }
    /**
     * Get PricingUnit value
     * @return \dgsoft\StructType\DgPricingUnit[]|null
     */
    public function getPricingUnit()
    {
        return $this->PricingUnit;
    }
    /**
     * Set PricingUnit value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricingUnit[] $pricingUnit
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setPricingUnit(array $pricingUnit = array())
    {
        foreach ($pricingUnit as $pTCFareBreakdownTypePricingUnitItem) {
            // validation for constraint: itemType
            if (!$pTCFareBreakdownTypePricingUnitItem instanceof \dgsoft\StructType\DgPricingUnit) {
                throw new \InvalidArgumentException(sprintf('The PricingUnit property can only contain items of \dgsoft\StructType\DgPricingUnit, "%s" given', is_object($pTCFareBreakdownTypePricingUnitItem) ? get_class($pTCFareBreakdownTypePricingUnitItem) : gettype($pTCFareBreakdownTypePricingUnitItem)), __LINE__);
            }
        }
        $this->PricingUnit = $pricingUnit;
        return $this;
    }
    /**
     * Add item to PricingUnit value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPricingUnit $item
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function addToPricingUnit(\dgsoft\StructType\DgPricingUnit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPricingUnit) {
            throw new \InvalidArgumentException(sprintf('The PricingUnit property can only contain items of \dgsoft\StructType\DgPricingUnit, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PricingUnit[] = $item;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @uses \dgsoft\EnumType\DgPricingSourceType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPricingSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingSource
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public function setPricingSource($pricingSource = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPricingSourceType::valueIsValid($pricingSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pricingSource, implode(', ', \dgsoft\EnumType\DgPricingSourceType::getValidValues())), __LINE__);
        }
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPTCFareBreakdownType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
