<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PNRRemarkChange StructType
 * @package Dg
 * @subpackage Structs
 */
class DgPNRRemarkChange extends AbstractStructBase
{
    /**
     * The ChangeDetailAction
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ChangeDetailAction;
    /**
     * The PNRRemark
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPNRRemarkInfo
     */
    public $PNRRemark;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $PersonName;
    /**
     * The SegmentIndex
     * @var int
     */
    public $SegmentIndex;
    /**
     * Constructor method for PNRRemarkChange
     * @uses DgPNRRemarkChange::setChangeDetailAction()
     * @uses DgPNRRemarkChange::setPNRRemark()
     * @uses DgPNRRemarkChange::setPersonName()
     * @uses DgPNRRemarkChange::setSegmentIndex()
     * @param string $changeDetailAction
     * @param \dgsoft\StructType\DgPNRRemarkInfo $pNRRemark
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @param int $segmentIndex
     */
    public function __construct($changeDetailAction = null, \dgsoft\StructType\DgPNRRemarkInfo $pNRRemark = null, \dgsoft\StructType\DgPersonNameType $personName = null, $segmentIndex = null)
    {
        $this
            ->setChangeDetailAction($changeDetailAction)
            ->setPNRRemark($pNRRemark)
            ->setPersonName($personName)
            ->setSegmentIndex($segmentIndex);
    }
    /**
     * Get ChangeDetailAction value
     * @return string
     */
    public function getChangeDetailAction()
    {
        return $this->ChangeDetailAction;
    }
    /**
     * Set ChangeDetailAction value
     * @uses \dgsoft\EnumType\DgChangeDetailActionTypes::valueIsValid()
     * @uses \dgsoft\EnumType\DgChangeDetailActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changeDetailAction
     * @return \dgsoft\StructType\DgPNRRemarkChange
     */
    public function setChangeDetailAction($changeDetailAction = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgChangeDetailActionTypes::valueIsValid($changeDetailAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $changeDetailAction, implode(', ', \dgsoft\EnumType\DgChangeDetailActionTypes::getValidValues())), __LINE__);
        }
        $this->ChangeDetailAction = $changeDetailAction;
        return $this;
    }
    /**
     * Get PNRRemark value
     * @return \dgsoft\StructType\DgPNRRemarkInfo|null
     */
    public function getPNRRemark()
    {
        return $this->PNRRemark;
    }
    /**
     * Set PNRRemark value
     * @param \dgsoft\StructType\DgPNRRemarkInfo $pNRRemark
     * @return \dgsoft\StructType\DgPNRRemarkChange
     */
    public function setPNRRemark(\dgsoft\StructType\DgPNRRemarkInfo $pNRRemark = null)
    {
        $this->PNRRemark = $pNRRemark;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @return \dgsoft\StructType\DgPNRRemarkChange
     */
    public function setPersonName(\dgsoft\StructType\DgPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get SegmentIndex value
     * @return int|null
     */
    public function getSegmentIndex()
    {
        return $this->SegmentIndex;
    }
    /**
     * Set SegmentIndex value
     * @param int $segmentIndex
     * @return \dgsoft\StructType\DgPNRRemarkChange
     */
    public function setSegmentIndex($segmentIndex = null)
    {
        // validation for constraint: int
        if (!is_null($segmentIndex) && !is_numeric($segmentIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($segmentIndex)), __LINE__);
        }
        $this->SegmentIndex = $segmentIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgPNRRemarkChange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
