<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationOption StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOriginDestinationOption extends DgOriginDestinationOptionType
{
    /**
     * The DirectionId
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DirectionId;
    /**
     * The OptionPricingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public $OptionPricingInfo;
    /**
     * The ItinBaseFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareType
     */
    public $ItinBaseFare;
    /**
     * The RefNumber
     * @var int
     */
    public $RefNumber;
    /**
     * The DirectionInd
     * @var string
     */
    public $DirectionInd;
    /**
     * The ElapsedTime
     * @var string
     */
    public $ElapsedTime;
    /**
     * The ProviderType
     * @var string
     */
    public $ProviderType;
    /**
     * Constructor method for OriginDestinationOption
     * @uses DgOriginDestinationOption::setDirectionId()
     * @uses DgOriginDestinationOption::setOptionPricingInfo()
     * @uses DgOriginDestinationOption::setItinBaseFare()
     * @uses DgOriginDestinationOption::setRefNumber()
     * @uses DgOriginDestinationOption::setDirectionInd()
     * @uses DgOriginDestinationOption::setElapsedTime()
     * @uses DgOriginDestinationOption::setProviderType()
     * @param int $directionId
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $optionPricingInfo
     * @param \dgsoft\StructType\DgFareType $itinBaseFare
     * @param int $refNumber
     * @param string $directionInd
     * @param string $elapsedTime
     * @param string $providerType
     */
    public function __construct($directionId = null, \dgsoft\StructType\DgAirItineraryPricingInfoType $optionPricingInfo = null, \dgsoft\StructType\DgFareType $itinBaseFare = null, $refNumber = null, $directionInd = null, $elapsedTime = null, $providerType = null)
    {
        $this
            ->setDirectionId($directionId)
            ->setOptionPricingInfo($optionPricingInfo)
            ->setItinBaseFare($itinBaseFare)
            ->setRefNumber($refNumber)
            ->setDirectionInd($directionInd)
            ->setElapsedTime($elapsedTime)
            ->setProviderType($providerType);
    }
    /**
     * Get DirectionId value
     * @return int
     */
    public function getDirectionId()
    {
        return $this->DirectionId;
    }
    /**
     * Set DirectionId value
     * @param int $directionId
     * @return \dgsoft\StructType\DgOriginDestinationOption
     */
    public function setDirectionId($directionId = null)
    {
        // validation for constraint: int
        if (!is_null($directionId) && !is_numeric($directionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($directionId)), __LINE__);
        }
        $this->DirectionId = $directionId;
        return $this;
    }
    /**
     * Get OptionPricingInfo value
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType|null
     */
    public function getOptionPricingInfo()
    {
        return $this->OptionPricingInfo;
    }
    /**
     * Set OptionPricingInfo value
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $optionPricingInfo
     * @return \dgsoft\StructType\DgOriginDestinationOption
     */
    public function setOptionPricingInfo(\dgsoft\StructType\DgAirItineraryPricingInfoType $optionPricingInfo = null)
    {
        $this->OptionPricingInfo = $optionPricingInfo;
        return $this;
    }
    /**
     * Get ItinBaseFare value
     * @return \dgsoft\StructType\DgFareType|null
     */
    public function getItinBaseFare()
    {
        return $this->ItinBaseFare;
    }
    /**
     * Set ItinBaseFare value
     * @param \dgsoft\StructType\DgFareType $itinBaseFare
     * @return \dgsoft\StructType\DgOriginDestinationOption
     */
    public function setItinBaseFare(\dgsoft\StructType\DgFareType $itinBaseFare = null)
    {
        $this->ItinBaseFare = $itinBaseFare;
        return $this;
    }
    /**
     * Get RefNumber value
     * @return int|null
     */
    public function getRefNumber()
    {
        return $this->RefNumber;
    }
    /**
     * Set RefNumber value
     * @param int $refNumber
     * @return \dgsoft\StructType\DgOriginDestinationOption
     */
    public function setRefNumber($refNumber = null)
    {
        // validation for constraint: int
        if (!is_null($refNumber) && !is_numeric($refNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($refNumber)), __LINE__);
        }
        $this->RefNumber = $refNumber;
        return $this;
    }
    /**
     * Get DirectionInd value
     * @return string|null
     */
    public function getDirectionInd()
    {
        return $this->DirectionInd;
    }
    /**
     * Set DirectionInd value
     * @uses \dgsoft\EnumType\DgAirTripType::valueIsValid()
     * @uses \dgsoft\EnumType\DgAirTripType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $directionInd
     * @return \dgsoft\StructType\DgOriginDestinationOption
     */
    public function setDirectionInd($directionInd = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAirTripType::valueIsValid($directionInd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $directionInd, implode(', ', \dgsoft\EnumType\DgAirTripType::getValidValues())), __LINE__);
        }
        $this->DirectionInd = $directionInd;
        return $this;
    }
    /**
     * Get ElapsedTime value
     * @return string|null
     */
    public function getElapsedTime()
    {
        return $this->ElapsedTime;
    }
    /**
     * Set ElapsedTime value
     * @param string $elapsedTime
     * @return \dgsoft\StructType\DgOriginDestinationOption
     */
    public function setElapsedTime($elapsedTime = null)
    {
        // validation for constraint: string
        if (!is_null($elapsedTime) && !is_string($elapsedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($elapsedTime)), __LINE__);
        }
        $this->ElapsedTime = $elapsedTime;
        return $this;
    }
    /**
     * Get ProviderType value
     * @return string|null
     */
    public function getProviderType()
    {
        return $this->ProviderType;
    }
    /**
     * Set ProviderType value
     * @param string $providerType
     * @return \dgsoft\StructType\DgOriginDestinationOption
     */
    public function setProviderType($providerType = null)
    {
        // validation for constraint: string
        if (!is_null($providerType) && !is_string($providerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerType)), __LINE__);
        }
        $this->ProviderType = $providerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOriginDestinationOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
