<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationInformation StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOriginDestinationInformation extends DgOriginDestinationInformationType
{
    /**
     * The AlternateLocationInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAlternateLocationInfo
     */
    public $AlternateLocationInfo;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The RefNumber
     * @var int
     */
    public $RefNumber;
    /**
     * Constructor method for OriginDestinationInformation
     * @uses DgOriginDestinationInformation::setAlternateLocationInfo()
     * @uses DgOriginDestinationInformation::setTPA_Extensions()
     * @uses DgOriginDestinationInformation::setRPH()
     * @uses DgOriginDestinationInformation::setRefNumber()
     * @param \dgsoft\StructType\DgAlternateLocationInfo $alternateLocationInfo
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $rPH
     * @param int $refNumber
     */
    public function __construct(\dgsoft\StructType\DgAlternateLocationInfo $alternateLocationInfo = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $rPH = null, $refNumber = null)
    {
        $this
            ->setAlternateLocationInfo($alternateLocationInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRPH($rPH)
            ->setRefNumber($refNumber);
    }
    /**
     * Get AlternateLocationInfo value
     * @return \dgsoft\StructType\DgAlternateLocationInfo|null
     */
    public function getAlternateLocationInfo()
    {
        return $this->AlternateLocationInfo;
    }
    /**
     * Set AlternateLocationInfo value
     * @param \dgsoft\StructType\DgAlternateLocationInfo $alternateLocationInfo
     * @return \dgsoft\StructType\DgOriginDestinationInformation
     */
    public function setAlternateLocationInfo(\dgsoft\StructType\DgAlternateLocationInfo $alternateLocationInfo = null)
    {
        $this->AlternateLocationInfo = $alternateLocationInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOriginDestinationInformation
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgOriginDestinationInformation
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get RefNumber value
     * @return int|null
     */
    public function getRefNumber()
    {
        return $this->RefNumber;
    }
    /**
     * Set RefNumber value
     * @param int $refNumber
     * @return \dgsoft\StructType\DgOriginDestinationInformation
     */
    public function setRefNumber($refNumber = null)
    {
        // validation for constraint: int
        if (!is_null($refNumber) && !is_numeric($refNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($refNumber)), __LINE__);
        }
        $this->RefNumber = $refNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOriginDestinationInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
