<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationCombinationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOriginDestinationCombinationType extends AbstractStructBase
{
    /**
     * The ForceETicket
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ForceETicket;
    /**
     * The CombinationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $CombinationID;
    /**
     * The ServiceFeeAmount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $ServiceFeeAmount;
    /**
     * The ValidatingAirlineCode
     * @var string
     */
    public $ValidatingAirlineCode;
    /**
     * The OriginIndex
     * @var int
     */
    public $OriginIndex;
    /**
     * The IndexList
     * @var string
     */
    public $IndexList;
    /**
     * The DestinationIndex
     * @var int
     */
    public $DestinationIndex;
    /**
     * The RecommendationID
     * @var int
     */
    public $RecommendationID;
    /**
     * The E_TicketEligibility
     * @var string
     */
    public $E_TicketEligibility;
    /**
     * Constructor method for OriginDestinationCombinationType
     * @uses DgOriginDestinationCombinationType::setForceETicket()
     * @uses DgOriginDestinationCombinationType::setCombinationID()
     * @uses DgOriginDestinationCombinationType::setServiceFeeAmount()
     * @uses DgOriginDestinationCombinationType::setValidatingAirlineCode()
     * @uses DgOriginDestinationCombinationType::setOriginIndex()
     * @uses DgOriginDestinationCombinationType::setIndexList()
     * @uses DgOriginDestinationCombinationType::setDestinationIndex()
     * @uses DgOriginDestinationCombinationType::setRecommendationID()
     * @uses DgOriginDestinationCombinationType::setE_TicketEligibility()
     * @param bool $forceETicket
     * @param int $combinationID
     * @param float $serviceFeeAmount
     * @param string $validatingAirlineCode
     * @param int $originIndex
     * @param string $indexList
     * @param int $destinationIndex
     * @param int $recommendationID
     * @param string $e_TicketEligibility
     */
    public function __construct($forceETicket = null, $combinationID = null, $serviceFeeAmount = null, $validatingAirlineCode = null, $originIndex = null, $indexList = null, $destinationIndex = null, $recommendationID = null, $e_TicketEligibility = null)
    {
        $this
            ->setForceETicket($forceETicket)
            ->setCombinationID($combinationID)
            ->setServiceFeeAmount($serviceFeeAmount)
            ->setValidatingAirlineCode($validatingAirlineCode)
            ->setOriginIndex($originIndex)
            ->setIndexList($indexList)
            ->setDestinationIndex($destinationIndex)
            ->setRecommendationID($recommendationID)
            ->setE_TicketEligibility($e_TicketEligibility);
    }
    /**
     * Get ForceETicket value
     * @return bool
     */
    public function getForceETicket()
    {
        return $this->ForceETicket;
    }
    /**
     * Set ForceETicket value
     * @param bool $forceETicket
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setForceETicket($forceETicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceETicket) && !is_bool($forceETicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forceETicket)), __LINE__);
        }
        $this->ForceETicket = $forceETicket;
        return $this;
    }
    /**
     * Get CombinationID value
     * @return int
     */
    public function getCombinationID()
    {
        return $this->CombinationID;
    }
    /**
     * Set CombinationID value
     * @param int $combinationID
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setCombinationID($combinationID = null)
    {
        // validation for constraint: int
        if (!is_null($combinationID) && !is_numeric($combinationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($combinationID)), __LINE__);
        }
        $this->CombinationID = $combinationID;
        return $this;
    }
    /**
     * Get ServiceFeeAmount value
     * @return float
     */
    public function getServiceFeeAmount()
    {
        return $this->ServiceFeeAmount;
    }
    /**
     * Set ServiceFeeAmount value
     * @param float $serviceFeeAmount
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setServiceFeeAmount($serviceFeeAmount = null)
    {
        $this->ServiceFeeAmount = $serviceFeeAmount;
        return $this;
    }
    /**
     * Get ValidatingAirlineCode value
     * @return string|null
     */
    public function getValidatingAirlineCode()
    {
        return $this->ValidatingAirlineCode;
    }
    /**
     * Set ValidatingAirlineCode value
     * @param string $validatingAirlineCode
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setValidatingAirlineCode($validatingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingAirlineCode) && !is_string($validatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validatingAirlineCode)), __LINE__);
        }
        $this->ValidatingAirlineCode = $validatingAirlineCode;
        return $this;
    }
    /**
     * Get OriginIndex value
     * @return int|null
     */
    public function getOriginIndex()
    {
        return $this->OriginIndex;
    }
    /**
     * Set OriginIndex value
     * @param int $originIndex
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setOriginIndex($originIndex = null)
    {
        // validation for constraint: int
        if (!is_null($originIndex) && !is_numeric($originIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($originIndex)), __LINE__);
        }
        $this->OriginIndex = $originIndex;
        return $this;
    }
    /**
     * Get IndexList value
     * @return string|null
     */
    public function getIndexList()
    {
        return $this->IndexList;
    }
    /**
     * Set IndexList value
     * @param string $indexList
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setIndexList($indexList = null)
    {
        // validation for constraint: string
        if (!is_null($indexList) && !is_string($indexList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($indexList)), __LINE__);
        }
        $this->IndexList = $indexList;
        return $this;
    }
    /**
     * Get DestinationIndex value
     * @return int|null
     */
    public function getDestinationIndex()
    {
        return $this->DestinationIndex;
    }
    /**
     * Set DestinationIndex value
     * @param int $destinationIndex
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setDestinationIndex($destinationIndex = null)
    {
        // validation for constraint: int
        if (!is_null($destinationIndex) && !is_numeric($destinationIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationIndex)), __LINE__);
        }
        $this->DestinationIndex = $destinationIndex;
        return $this;
    }
    /**
     * Get RecommendationID value
     * @return int|null
     */
    public function getRecommendationID()
    {
        return $this->RecommendationID;
    }
    /**
     * Set RecommendationID value
     * @param int $recommendationID
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setRecommendationID($recommendationID = null)
    {
        // validation for constraint: int
        if (!is_null($recommendationID) && !is_numeric($recommendationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recommendationID)), __LINE__);
        }
        $this->RecommendationID = $recommendationID;
        return $this;
    }
    /**
     * Get E_TicketEligibility value
     * @return string|null
     */
    public function getE_TicketEligibility()
    {
        return $this->E_TicketEligibility;
    }
    /**
     * Set E_TicketEligibility value
     * @param string $e_TicketEligibility
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public function setE_TicketEligibility($e_TicketEligibility = null)
    {
        // validation for constraint: string
        if (!is_null($e_TicketEligibility) && !is_string($e_TicketEligibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e_TicketEligibility)), __LINE__);
        }
        $this->E_TicketEligibility = $e_TicketEligibility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOriginDestinationCombinationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
