<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrganizationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOrganizationType extends AbstractStructBase
{
    /**
     * The OrgMemberName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOrgMemberName
     */
    public $OrgMemberName;
    /**
     * The OrgName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $OrgName;
    /**
     * The RelatedOrgName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $RelatedOrgName;
    /**
     * The TravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The DefaultInd
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The OfficeType
     * @var string
     */
    public $OfficeType;
    /**
     * Constructor method for OrganizationType
     * @uses DgOrganizationType::setOrgMemberName()
     * @uses DgOrganizationType::setOrgName()
     * @uses DgOrganizationType::setRelatedOrgName()
     * @uses DgOrganizationType::setTravelArranger()
     * @uses DgOrganizationType::setDefaultInd()
     * @uses DgOrganizationType::setShareSynchInd()
     * @uses DgOrganizationType::setShareMarketInd()
     * @uses DgOrganizationType::setEffectiveDate()
     * @uses DgOrganizationType::setExpireDate()
     * @uses DgOrganizationType::setOfficeType()
     * @param \dgsoft\StructType\DgOrgMemberName $orgMemberName
     * @param \dgsoft\StructType\DgCompanyNameType $orgName
     * @param \dgsoft\StructType\DgCompanyNameType[] $relatedOrgName
     * @param \dgsoft\StructType\DgTravelArrangerType[] $travelArranger
     * @param bool $defaultInd
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $effectiveDate
     * @param string $expireDate
     * @param string $officeType
     */
    public function __construct(\dgsoft\StructType\DgOrgMemberName $orgMemberName = null, \dgsoft\StructType\DgCompanyNameType $orgName = null, array $relatedOrgName = array(), array $travelArranger = array(), $defaultInd = false, $shareSynchInd = null, $shareMarketInd = null, $effectiveDate = null, $expireDate = null, $officeType = null)
    {
        $this
            ->setOrgMemberName($orgMemberName)
            ->setOrgName($orgName)
            ->setRelatedOrgName($relatedOrgName)
            ->setTravelArranger($travelArranger)
            ->setDefaultInd($defaultInd)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setOfficeType($officeType);
    }
    /**
     * Get OrgMemberName value
     * @return \dgsoft\StructType\DgOrgMemberName|null
     */
    public function getOrgMemberName()
    {
        return $this->OrgMemberName;
    }
    /**
     * Set OrgMemberName value
     * @param \dgsoft\StructType\DgOrgMemberName $orgMemberName
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setOrgMemberName(\dgsoft\StructType\DgOrgMemberName $orgMemberName = null)
    {
        $this->OrgMemberName = $orgMemberName;
        return $this;
    }
    /**
     * Get OrgName value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getOrgName()
    {
        return $this->OrgName;
    }
    /**
     * Set OrgName value
     * @param \dgsoft\StructType\DgCompanyNameType $orgName
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setOrgName(\dgsoft\StructType\DgCompanyNameType $orgName = null)
    {
        $this->OrgName = $orgName;
        return $this;
    }
    /**
     * Get RelatedOrgName value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getRelatedOrgName()
    {
        return $this->RelatedOrgName;
    }
    /**
     * Set RelatedOrgName value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $relatedOrgName
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setRelatedOrgName(array $relatedOrgName = array())
    {
        foreach ($relatedOrgName as $organizationTypeRelatedOrgNameItem) {
            // validation for constraint: itemType
            if (!$organizationTypeRelatedOrgNameItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The RelatedOrgName property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($organizationTypeRelatedOrgNameItem) ? get_class($organizationTypeRelatedOrgNameItem) : gettype($organizationTypeRelatedOrgNameItem)), __LINE__);
            }
        }
        $this->RelatedOrgName = $relatedOrgName;
        return $this;
    }
    /**
     * Add item to RelatedOrgName value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function addToRelatedOrgName(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The RelatedOrgName property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedOrgName[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \dgsoft\StructType\DgTravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelArrangerType[] $travelArranger
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        foreach ($travelArranger as $organizationTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$organizationTypeTravelArrangerItem instanceof \dgsoft\StructType\DgTravelArrangerType) {
                throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \dgsoft\StructType\DgTravelArrangerType, "%s" given', is_object($organizationTypeTravelArrangerItem) ? get_class($organizationTypeTravelArrangerItem) : gettype($organizationTypeTravelArrangerItem)), __LINE__);
            }
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelArrangerType $item
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function addToTravelArranger(\dgsoft\StructType\DgTravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \dgsoft\StructType\DgTravelArrangerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @uses \dgsoft\EnumType\DgOfficeLocationType::valueIsValid()
     * @uses \dgsoft\EnumType\DgOfficeLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeType
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOfficeLocationType::valueIsValid($officeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $officeType, implode(', ', \dgsoft\EnumType\DgOfficeLocationType::getValidValues())), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOrganizationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
