<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organization StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOrganization extends DgEntity
{
    /**
     * The LogoFileID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $LogoFileID;
    /**
     * The MarketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $MarketID;
    /**
     * The IsBSPMarket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IsBSPMarket;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The JudicalRecordNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JudicalRecordNo;
    /**
     * The TypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCode;
    /**
     * The ShortName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortName;
    /**
     * The IATA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IATA;
    /**
     * The OfficeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfficeID;
    /**
     * The SubAgencyOID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubAgencyOID;
    /**
     * The OfferOfficeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OfferOfficeID;
    /**
     * The Branches
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOrganization
     */
    public $Branches;
    /**
     * Constructor method for Organization
     * @uses DgOrganization::setLogoFileID()
     * @uses DgOrganization::setMarketID()
     * @uses DgOrganization::setIsBSPMarket()
     * @uses DgOrganization::setCode()
     * @uses DgOrganization::setTitle()
     * @uses DgOrganization::setJudicalRecordNo()
     * @uses DgOrganization::setTypeCode()
     * @uses DgOrganization::setShortName()
     * @uses DgOrganization::setIATA()
     * @uses DgOrganization::setOfficeID()
     * @uses DgOrganization::setSubAgencyOID()
     * @uses DgOrganization::setOfferOfficeID()
     * @uses DgOrganization::setBranches()
     * @param string $logoFileID
     * @param string $marketID
     * @param bool $isBSPMarket
     * @param string $code
     * @param string $title
     * @param string $judicalRecordNo
     * @param string $typeCode
     * @param string $shortName
     * @param string $iATA
     * @param string $officeID
     * @param string $subAgencyOID
     * @param string $offerOfficeID
     * @param \dgsoft\ArrayType\DgArrayOfOrganization $branches
     */
    public function __construct($logoFileID = null, $marketID = null, $isBSPMarket = null, $code = null, $title = null, $judicalRecordNo = null, $typeCode = null, $shortName = null, $iATA = null, $officeID = null, $subAgencyOID = null, $offerOfficeID = null, \dgsoft\ArrayType\DgArrayOfOrganization $branches = null)
    {
        $this
            ->setLogoFileID($logoFileID)
            ->setMarketID($marketID)
            ->setIsBSPMarket($isBSPMarket)
            ->setCode($code)
            ->setTitle($title)
            ->setJudicalRecordNo($judicalRecordNo)
            ->setTypeCode($typeCode)
            ->setShortName($shortName)
            ->setIATA($iATA)
            ->setOfficeID($officeID)
            ->setSubAgencyOID($subAgencyOID)
            ->setOfferOfficeID($offerOfficeID)
            ->setBranches($branches);
    }
    /**
     * Get LogoFileID value
     * @return string
     */
    public function getLogoFileID()
    {
        return $this->LogoFileID;
    }
    /**
     * Set LogoFileID value
     * @param string $logoFileID
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setLogoFileID($logoFileID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($logoFileID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $logoFileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($logoFileID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($logoFileID) && !is_string($logoFileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logoFileID)), __LINE__);
        }
        $this->LogoFileID = $logoFileID;
        return $this;
    }
    /**
     * Get MarketID value
     * @return string
     */
    public function getMarketID()
    {
        return $this->MarketID;
    }
    /**
     * Set MarketID value
     * @param string $marketID
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setMarketID($marketID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($marketID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $marketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($marketID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($marketID) && !is_string($marketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketID)), __LINE__);
        }
        $this->MarketID = $marketID;
        return $this;
    }
    /**
     * Get IsBSPMarket value
     * @return bool
     */
    public function getIsBSPMarket()
    {
        return $this->IsBSPMarket;
    }
    /**
     * Set IsBSPMarket value
     * @param bool $isBSPMarket
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setIsBSPMarket($isBSPMarket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBSPMarket) && !is_bool($isBSPMarket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBSPMarket)), __LINE__);
        }
        $this->IsBSPMarket = $isBSPMarket;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get JudicalRecordNo value
     * @return string|null
     */
    public function getJudicalRecordNo()
    {
        return $this->JudicalRecordNo;
    }
    /**
     * Set JudicalRecordNo value
     * @param string $judicalRecordNo
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setJudicalRecordNo($judicalRecordNo = null)
    {
        // validation for constraint: string
        if (!is_null($judicalRecordNo) && !is_string($judicalRecordNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($judicalRecordNo)), __LINE__);
        }
        $this->JudicalRecordNo = $judicalRecordNo;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get ShortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->ShortName;
    }
    /**
     * Set ShortName value
     * @param string $shortName
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortName)), __LINE__);
        }
        $this->ShortName = $shortName;
        return $this;
    }
    /**
     * Get IATA value
     * @return string|null
     */
    public function getIATA()
    {
        return $this->IATA;
    }
    /**
     * Set IATA value
     * @param string $iATA
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setIATA($iATA = null)
    {
        // validation for constraint: string
        if (!is_null($iATA) && !is_string($iATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iATA)), __LINE__);
        }
        $this->IATA = $iATA;
        return $this;
    }
    /**
     * Get OfficeID value
     * @return string|null
     */
    public function getOfficeID()
    {
        return $this->OfficeID;
    }
    /**
     * Set OfficeID value
     * @param string $officeID
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setOfficeID($officeID = null)
    {
        // validation for constraint: string
        if (!is_null($officeID) && !is_string($officeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($officeID)), __LINE__);
        }
        $this->OfficeID = $officeID;
        return $this;
    }
    /**
     * Get SubAgencyOID value
     * @return string|null
     */
    public function getSubAgencyOID()
    {
        return $this->SubAgencyOID;
    }
    /**
     * Set SubAgencyOID value
     * @param string $subAgencyOID
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setSubAgencyOID($subAgencyOID = null)
    {
        // validation for constraint: string
        if (!is_null($subAgencyOID) && !is_string($subAgencyOID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subAgencyOID)), __LINE__);
        }
        $this->SubAgencyOID = $subAgencyOID;
        return $this;
    }
    /**
     * Get OfferOfficeID value
     * @return string|null
     */
    public function getOfferOfficeID()
    {
        return $this->OfferOfficeID;
    }
    /**
     * Set OfferOfficeID value
     * @param string $offerOfficeID
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setOfferOfficeID($offerOfficeID = null)
    {
        // validation for constraint: string
        if (!is_null($offerOfficeID) && !is_string($offerOfficeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offerOfficeID)), __LINE__);
        }
        $this->OfferOfficeID = $offerOfficeID;
        return $this;
    }
    /**
     * Get Branches value
     * @return \dgsoft\ArrayType\DgArrayOfOrganization|null
     */
    public function getBranches()
    {
        return $this->Branches;
    }
    /**
     * Set Branches value
     * @param \dgsoft\ArrayType\DgArrayOfOrganization $branches
     * @return \dgsoft\StructType\DgOrganization
     */
    public function setBranches(\dgsoft\ArrayType\DgArrayOfOrganization $branches = null)
    {
        $this->Branches = $branches;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOrganization
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
