<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffLocationServiceType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOffLocationServiceType extends DgOffLocationServiceCoreType
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOffLocationServiceTypeTelephone
     */
    public $Telephone;
    /**
     * The SpecInstructions
     * @var string
     */
    public $SpecInstructions;
    /**
     * Constructor method for OffLocationServiceType
     * @uses DgOffLocationServiceType::setPersonName()
     * @uses DgOffLocationServiceType::setTelephone()
     * @uses DgOffLocationServiceType::setSpecInstructions()
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @param \dgsoft\StructType\DgOffLocationServiceTypeTelephone $telephone
     * @param string $specInstructions
     */
    public function __construct(\dgsoft\StructType\DgPersonNameType $personName = null, \dgsoft\StructType\DgOffLocationServiceTypeTelephone $telephone = null, $specInstructions = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setSpecInstructions($specInstructions);
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @return \dgsoft\StructType\DgOffLocationServiceType
     */
    public function setPersonName(\dgsoft\StructType\DgPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \dgsoft\StructType\DgOffLocationServiceTypeTelephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \dgsoft\StructType\DgOffLocationServiceTypeTelephone $telephone
     * @return \dgsoft\StructType\DgOffLocationServiceType
     */
    public function setTelephone(\dgsoft\StructType\DgOffLocationServiceTypeTelephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get SpecInstructions value
     * @return string|null
     */
    public function getSpecInstructions()
    {
        return $this->SpecInstructions;
    }
    /**
     * Set SpecInstructions value
     * @param string $specInstructions
     * @return \dgsoft\StructType\DgOffLocationServiceType
     */
    public function setSpecInstructions($specInstructions = null)
    {
        // validation for constraint: string
        if (!is_null($specInstructions) && !is_string($specInstructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specInstructions)), __LINE__);
        }
        $this->SpecInstructions = $specInstructions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOffLocationServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
