<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehRateRuleRSRateRulesAdvanceBooking StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehRateRuleRSRateRulesAdvanceBooking extends AbstractStructBase
{
    /**
     * The AbsoluteDeadline
     * @var string
     */
    public $AbsoluteDeadline;
    /**
     * The OffsetTimeUnit
     * @var string
     */
    public $OffsetTimeUnit;
    /**
     * The OffsetUnitMultiplier
     * @var int
     */
    public $OffsetUnitMultiplier;
    /**
     * The OffsetDropTime
     * @var string
     */
    public $OffsetDropTime;
    /**
     * The RequiredInd
     * @var bool
     */
    public $RequiredInd;
    /**
     * Constructor method for OTA_VehRateRuleRSRateRulesAdvanceBooking
     * @uses DgOTA_VehRateRuleRSRateRulesAdvanceBooking::setAbsoluteDeadline()
     * @uses DgOTA_VehRateRuleRSRateRulesAdvanceBooking::setOffsetTimeUnit()
     * @uses DgOTA_VehRateRuleRSRateRulesAdvanceBooking::setOffsetUnitMultiplier()
     * @uses DgOTA_VehRateRuleRSRateRulesAdvanceBooking::setOffsetDropTime()
     * @uses DgOTA_VehRateRuleRSRateRulesAdvanceBooking::setRequiredInd()
     * @param string $absoluteDeadline
     * @param string $offsetTimeUnit
     * @param int $offsetUnitMultiplier
     * @param string $offsetDropTime
     * @param bool $requiredInd
     */
    public function __construct($absoluteDeadline = null, $offsetTimeUnit = null, $offsetUnitMultiplier = null, $offsetDropTime = null, $requiredInd = null)
    {
        $this
            ->setAbsoluteDeadline($absoluteDeadline)
            ->setOffsetTimeUnit($offsetTimeUnit)
            ->setOffsetUnitMultiplier($offsetUnitMultiplier)
            ->setOffsetDropTime($offsetDropTime)
            ->setRequiredInd($requiredInd);
    }
    /**
     * Get AbsoluteDeadline value
     * @return string|null
     */
    public function getAbsoluteDeadline()
    {
        return $this->AbsoluteDeadline;
    }
    /**
     * Set AbsoluteDeadline value
     * @param string $absoluteDeadline
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesAdvanceBooking
     */
    public function setAbsoluteDeadline($absoluteDeadline = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteDeadline) && !is_string($absoluteDeadline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($absoluteDeadline)), __LINE__);
        }
        $this->AbsoluteDeadline = $absoluteDeadline;
        return $this;
    }
    /**
     * Get OffsetTimeUnit value
     * @return string|null
     */
    public function getOffsetTimeUnit()
    {
        return $this->OffsetTimeUnit;
    }
    /**
     * Set OffsetTimeUnit value
     * @uses \dgsoft\EnumType\DgTimeUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $offsetTimeUnit
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesAdvanceBooking
     */
    public function setOffsetTimeUnit($offsetTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTimeUnitType::valueIsValid($offsetTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $offsetTimeUnit, implode(', ', \dgsoft\EnumType\DgTimeUnitType::getValidValues())), __LINE__);
        }
        $this->OffsetTimeUnit = $offsetTimeUnit;
        return $this;
    }
    /**
     * Get OffsetUnitMultiplier value
     * @return int|null
     */
    public function getOffsetUnitMultiplier()
    {
        return $this->OffsetUnitMultiplier;
    }
    /**
     * Set OffsetUnitMultiplier value
     * @param int $offsetUnitMultiplier
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesAdvanceBooking
     */
    public function setOffsetUnitMultiplier($offsetUnitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($offsetUnitMultiplier) && !is_numeric($offsetUnitMultiplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offsetUnitMultiplier)), __LINE__);
        }
        $this->OffsetUnitMultiplier = $offsetUnitMultiplier;
        return $this;
    }
    /**
     * Get OffsetDropTime value
     * @return string|null
     */
    public function getOffsetDropTime()
    {
        return $this->OffsetDropTime;
    }
    /**
     * Set OffsetDropTime value
     * @uses \dgsoft\EnumType\DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime::valueIsValid()
     * @uses \dgsoft\EnumType\DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $offsetDropTime
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesAdvanceBooking
     */
    public function setOffsetDropTime($offsetDropTime = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime::valueIsValid($offsetDropTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $offsetDropTime, implode(', ', \dgsoft\EnumType\DgVehicleRentalRateTypeRateGuaranteeOffsetDropTime::getValidValues())), __LINE__);
        }
        $this->OffsetDropTime = $offsetDropTime;
        return $this;
    }
    /**
     * Get RequiredInd value
     * @return bool|null
     */
    public function getRequiredInd()
    {
        return $this->RequiredInd;
    }
    /**
     * Set RequiredInd value
     * @param bool $requiredInd
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesAdvanceBooking
     */
    public function setRequiredInd($requiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiredInd) && !is_bool($requiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requiredInd)), __LINE__);
        }
        $this->RequiredInd = $requiredInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesAdvanceBooking
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
