<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_ReadRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_ReadRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $BookingReferenceID;
    /**
     * The ReadRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgReadRequests
     */
    public $ReadRequests;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The ReqRespVersion
     * @var string
     */
    public $ReqRespVersion;
    /**
     * The ReservationType
     * @var string
     */
    public $ReservationType;
    /**
     * The ReturnListIndicator
     * @var bool
     */
    public $ReturnListIndicator;
    /**
     * The MoreIndicator
     * @var bool
     */
    public $MoreIndicator;
    /**
     * The MoreDataEchoToken
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * Constructor method for OTA_ReadRQ
     * @uses DgOTA_ReadRQ::setVersion()
     * @uses DgOTA_ReadRQ::setPOS()
     * @uses DgOTA_ReadRQ::setBookingReferenceID()
     * @uses DgOTA_ReadRQ::setReadRequests()
     * @uses DgOTA_ReadRQ::setEchoToken()
     * @uses DgOTA_ReadRQ::setTimeStamp()
     * @uses DgOTA_ReadRQ::setTarget()
     * @uses DgOTA_ReadRQ::setTransactionIdentifier()
     * @uses DgOTA_ReadRQ::setSequenceNmbr()
     * @uses DgOTA_ReadRQ::setTransactionStatusCode()
     * @uses DgOTA_ReadRQ::setRetransmissionIndicator()
     * @uses DgOTA_ReadRQ::setReqRespVersion()
     * @uses DgOTA_ReadRQ::setReservationType()
     * @uses DgOTA_ReadRQ::setReturnListIndicator()
     * @uses DgOTA_ReadRQ::setMoreIndicator()
     * @uses DgOTA_ReadRQ::setMoreDataEchoToken()
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @param \dgsoft\StructType\DgReadRequests $readRequests
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $reqRespVersion
     * @param string $reservationType
     * @param bool $returnListIndicator
     * @param bool $moreIndicator
     * @param string $moreDataEchoToken
     */
    public function __construct($version = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null, \dgsoft\StructType\DgReadRequests $readRequests = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $reqRespVersion = null, $reservationType = null, $returnListIndicator = null, $moreIndicator = null, $moreDataEchoToken = null)
    {
        $this
            ->setVersion($version)
            ->setPOS($pOS)
            ->setBookingReferenceID($bookingReferenceID)
            ->setReadRequests($readRequests)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setReqRespVersion($reqRespVersion)
            ->setReservationType($reservationType)
            ->setReturnListIndicator($returnListIndicator)
            ->setMoreIndicator($moreIndicator)
            ->setMoreDataEchoToken($moreDataEchoToken);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null)
    {
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get ReadRequests value
     * @return \dgsoft\StructType\DgReadRequests|null
     */
    public function getReadRequests()
    {
        return $this->ReadRequests;
    }
    /**
     * Set ReadRequests value
     * @param \dgsoft\StructType\DgReadRequests $readRequests
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setReadRequests(\dgsoft\StructType\DgReadRequests $readRequests = null)
    {
        $this->ReadRequests = $readRequests;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get ReqRespVersion value
     * @return string|null
     */
    public function getReqRespVersion()
    {
        return $this->ReqRespVersion;
    }
    /**
     * Set ReqRespVersion value
     * @param string $reqRespVersion
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setReqRespVersion($reqRespVersion = null)
    {
        // validation for constraint: string
        if (!is_null($reqRespVersion) && !is_string($reqRespVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqRespVersion)), __LINE__);
        }
        $this->ReqRespVersion = $reqRespVersion;
        return $this;
    }
    /**
     * Get ReservationType value
     * @return string|null
     */
    public function getReservationType()
    {
        return $this->ReservationType;
    }
    /**
     * Set ReservationType value
     * @param string $reservationType
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setReservationType($reservationType = null)
    {
        // validation for constraint: string
        if (!is_null($reservationType) && !is_string($reservationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationType)), __LINE__);
        }
        $this->ReservationType = $reservationType;
        return $this;
    }
    /**
     * Get ReturnListIndicator value
     * @return bool|null
     */
    public function getReturnListIndicator()
    {
        return $this->ReturnListIndicator;
    }
    /**
     * Set ReturnListIndicator value
     * @param bool $returnListIndicator
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setReturnListIndicator($returnListIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnListIndicator) && !is_bool($returnListIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($returnListIndicator)), __LINE__);
        }
        $this->ReturnListIndicator = $returnListIndicator;
        return $this;
    }
    /**
     * Get MoreIndicator value
     * @return bool|null
     */
    public function getMoreIndicator()
    {
        return $this->MoreIndicator;
    }
    /**
     * Set MoreIndicator value
     * @param bool $moreIndicator
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setMoreIndicator($moreIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreIndicator) && !is_bool($moreIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreIndicator)), __LINE__);
        }
        $this->MoreIndicator = $moreIndicator;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_ReadRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
