<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_InsurancePlanSearchRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_InsurancePlanSearchRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The DetailResponse
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $DetailResponse;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The CoveragePreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQCoveragePreference
     */
    public $CoveragePreferences;
    /**
     * The SearchTripInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo
     */
    public $SearchTripInfo;
    /**
     * The SearchFlightInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchFlightInfo
     */
    public $SearchFlightInfo;
    /**
     * The SearchTravInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTravInfo
     */
    public $SearchTravInfo;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The SearchResponseFilter
     * @var string
     */
    public $SearchResponseFilter;
    /**
     * Constructor method for OTA_InsurancePlanSearchRQ
     * @uses DgOTA_InsurancePlanSearchRQ::setVersion()
     * @uses DgOTA_InsurancePlanSearchRQ::setDetailResponse()
     * @uses DgOTA_InsurancePlanSearchRQ::setPOS()
     * @uses DgOTA_InsurancePlanSearchRQ::setCoveragePreferences()
     * @uses DgOTA_InsurancePlanSearchRQ::setSearchTripInfo()
     * @uses DgOTA_InsurancePlanSearchRQ::setSearchFlightInfo()
     * @uses DgOTA_InsurancePlanSearchRQ::setSearchTravInfo()
     * @uses DgOTA_InsurancePlanSearchRQ::setEchoToken()
     * @uses DgOTA_InsurancePlanSearchRQ::setTimeStamp()
     * @uses DgOTA_InsurancePlanSearchRQ::setTarget()
     * @uses DgOTA_InsurancePlanSearchRQ::setTransactionIdentifier()
     * @uses DgOTA_InsurancePlanSearchRQ::setSequenceNmbr()
     * @uses DgOTA_InsurancePlanSearchRQ::setTransactionStatusCode()
     * @uses DgOTA_InsurancePlanSearchRQ::setRetransmissionIndicator()
     * @uses DgOTA_InsurancePlanSearchRQ::setSearchResponseFilter()
     * @param float $version
     * @param bool $detailResponse
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQCoveragePreference $coveragePreferences
     * @param \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo $searchTripInfo
     * @param \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchFlightInfo $searchFlightInfo
     * @param \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTravInfo $searchTravInfo
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $searchResponseFilter
     */
    public function __construct($version = null, $detailResponse = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQCoveragePreference $coveragePreferences = null, \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo $searchTripInfo = null, \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchFlightInfo $searchFlightInfo = null, \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTravInfo $searchTravInfo = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $searchResponseFilter = null)
    {
        $this
            ->setVersion($version)
            ->setDetailResponse($detailResponse)
            ->setPOS($pOS)
            ->setCoveragePreferences($coveragePreferences)
            ->setSearchTripInfo($searchTripInfo)
            ->setSearchFlightInfo($searchFlightInfo)
            ->setSearchTravInfo($searchTravInfo)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setSearchResponseFilter($searchResponseFilter);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get DetailResponse value
     * @return bool
     */
    public function getDetailResponse()
    {
        return $this->DetailResponse;
    }
    /**
     * Set DetailResponse value
     * @param bool $detailResponse
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setDetailResponse($detailResponse = null)
    {
        // validation for constraint: boolean
        if (!is_null($detailResponse) && !is_bool($detailResponse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($detailResponse)), __LINE__);
        }
        $this->DetailResponse = $detailResponse;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get CoveragePreferences value
     * @return \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQCoveragePreference|null
     */
    public function getCoveragePreferences()
    {
        return $this->CoveragePreferences;
    }
    /**
     * Set CoveragePreferences value
     * @param \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQCoveragePreference $coveragePreferences
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setCoveragePreferences(\dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQCoveragePreference $coveragePreferences = null)
    {
        $this->CoveragePreferences = $coveragePreferences;
        return $this;
    }
    /**
     * Get SearchTripInfo value
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo|null
     */
    public function getSearchTripInfo()
    {
        return $this->SearchTripInfo;
    }
    /**
     * Set SearchTripInfo value
     * @param \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo $searchTripInfo
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setSearchTripInfo(\dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo $searchTripInfo = null)
    {
        $this->SearchTripInfo = $searchTripInfo;
        return $this;
    }
    /**
     * Get SearchFlightInfo value
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchFlightInfo|null
     */
    public function getSearchFlightInfo()
    {
        return $this->SearchFlightInfo;
    }
    /**
     * Set SearchFlightInfo value
     * @param \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchFlightInfo $searchFlightInfo
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setSearchFlightInfo(\dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchFlightInfo $searchFlightInfo = null)
    {
        $this->SearchFlightInfo = $searchFlightInfo;
        return $this;
    }
    /**
     * Get SearchTravInfo value
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTravInfo|null
     */
    public function getSearchTravInfo()
    {
        return $this->SearchTravInfo;
    }
    /**
     * Set SearchTravInfo value
     * @param \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTravInfo $searchTravInfo
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setSearchTravInfo(\dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTravInfo $searchTravInfo = null)
    {
        $this->SearchTravInfo = $searchTravInfo;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_InsurancePlanSearchRQTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_InsurancePlanSearchRQTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_InsurancePlanSearchRQTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_InsurancePlanSearchRQTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_InsurancePlanSearchRQTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_InsurancePlanSearchRQTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_InsurancePlanSearchRQTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_InsurancePlanSearchRQTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get SearchResponseFilter value
     * @return string|null
     */
    public function getSearchResponseFilter()
    {
        return $this->SearchResponseFilter;
    }
    /**
     * Set SearchResponseFilter value
     * @param string $searchResponseFilter
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public function setSearchResponseFilter($searchResponseFilter = null)
    {
        // validation for constraint: string
        if (!is_null($searchResponseFilter) && !is_string($searchResponseFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchResponseFilter)), __LINE__);
        }
        $this->SearchResponseFilter = $searchResponseFilter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
