<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_InsuranceBookRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_InsuranceBookRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The PlanForBookRQ
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ[]
     */
    public $PlanForBookRQ;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The ControlNumber
     * @var string
     */
    public $ControlNumber;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_InsuranceBookRQ
     * @uses DgOTA_InsuranceBookRQ::setVersion()
     * @uses DgOTA_InsuranceBookRQ::setPOS()
     * @uses DgOTA_InsuranceBookRQ::setPlanForBookRQ()
     * @uses DgOTA_InsuranceBookRQ::setReferenceNumber()
     * @uses DgOTA_InsuranceBookRQ::setControlNumber()
     * @uses DgOTA_InsuranceBookRQ::setEchoToken()
     * @uses DgOTA_InsuranceBookRQ::setTimeStamp()
     * @uses DgOTA_InsuranceBookRQ::setTarget()
     * @uses DgOTA_InsuranceBookRQ::setTransactionIdentifier()
     * @uses DgOTA_InsuranceBookRQ::setSequenceNmbr()
     * @uses DgOTA_InsuranceBookRQ::setTransactionStatusCode()
     * @uses DgOTA_InsuranceBookRQ::setRetransmissionIndicator()
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ[] $planForBookRQ
     * @param string $referenceNumber
     * @param string $controlNumber
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct($version = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, array $planForBookRQ = array(), $referenceNumber = null, $controlNumber = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setVersion($version)
            ->setPOS($pOS)
            ->setPlanForBookRQ($planForBookRQ)
            ->setReferenceNumber($referenceNumber)
            ->setControlNumber($controlNumber)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get PlanForBookRQ value
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ[]|null
     */
    public function getPlanForBookRQ()
    {
        return $this->PlanForBookRQ;
    }
    /**
     * Set PlanForBookRQ value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ[] $planForBookRQ
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setPlanForBookRQ(array $planForBookRQ = array())
    {
        foreach ($planForBookRQ as $oTA_InsuranceBookRQPlanForBookRQItem) {
            // validation for constraint: itemType
            if (!$oTA_InsuranceBookRQPlanForBookRQItem instanceof \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ) {
                throw new \InvalidArgumentException(sprintf('The PlanForBookRQ property can only contain items of \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ, "%s" given', is_object($oTA_InsuranceBookRQPlanForBookRQItem) ? get_class($oTA_InsuranceBookRQPlanForBookRQItem) : gettype($oTA_InsuranceBookRQPlanForBookRQItem)), __LINE__);
            }
        }
        $this->PlanForBookRQ = $planForBookRQ;
        return $this;
    }
    /**
     * Add item to PlanForBookRQ value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ $item
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function addToPlanForBookRQ(\dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ) {
            throw new \InvalidArgumentException(sprintf('The PlanForBookRQ property can only contain items of \dgsoft\StructType\DgOTA_InsuranceBookRQPlanForBookRQ, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlanForBookRQ[] = $item;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ControlNumber value
     * @return string|null
     */
    public function getControlNumber()
    {
        return $this->ControlNumber;
    }
    /**
     * Set ControlNumber value
     * @param string $controlNumber
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setControlNumber($controlNumber = null)
    {
        // validation for constraint: string
        if (!is_null($controlNumber) && !is_string($controlNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controlNumber)), __LINE__);
        }
        $this->ControlNumber = $controlNumber;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_InsuranceBookRQTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_InsuranceBookRQTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_InsuranceBookRQTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_InsuranceBookRQTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_InsuranceBookRQTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_InsuranceBookRQTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_InsuranceBookRQTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_InsuranceBookRQTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
