<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelResRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_HotelResRS extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The HotelPriceChangeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelPriceChangeInfo
     */
    public $HotelPriceChangeInfo;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The HotelReservations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelReservationsType
     */
    public $HotelReservations;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfWarningType
     */
    public $Warnings;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSuccessType
     */
    public $Success;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The ResResponseType
     * @var string
     */
    public $ResResponseType;
    /**
     * Constructor method for OTA_HotelResRS
     * @uses DgOTA_HotelResRS::setVersion()
     * @uses DgOTA_HotelResRS::setHotelPriceChangeInfo()
     * @uses DgOTA_HotelResRS::setPOS()
     * @uses DgOTA_HotelResRS::setHotelReservations()
     * @uses DgOTA_HotelResRS::setWarnings()
     * @uses DgOTA_HotelResRS::setSuccess()
     * @uses DgOTA_HotelResRS::setErrors()
     * @uses DgOTA_HotelResRS::setReferenceNumber()
     * @uses DgOTA_HotelResRS::setEchoToken()
     * @uses DgOTA_HotelResRS::setTimeStamp()
     * @uses DgOTA_HotelResRS::setTarget()
     * @uses DgOTA_HotelResRS::setTransactionIdentifier()
     * @uses DgOTA_HotelResRS::setSequenceNmbr()
     * @uses DgOTA_HotelResRS::setTransactionStatusCode()
     * @uses DgOTA_HotelResRS::setRetransmissionIndicator()
     * @uses DgOTA_HotelResRS::setResResponseType()
     * @param float $version
     * @param \dgsoft\StructType\DgHotelPriceChangeInfo $hotelPriceChangeInfo
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgHotelReservationsType $hotelReservations
     * @param \dgsoft\ArrayType\DgArrayOfWarningType $warnings
     * @param \dgsoft\StructType\DgSuccessType $success
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param string $referenceNumber
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $resResponseType
     */
    public function __construct($version = null, \dgsoft\StructType\DgHotelPriceChangeInfo $hotelPriceChangeInfo = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\StructType\DgHotelReservationsType $hotelReservations = null, \dgsoft\ArrayType\DgArrayOfWarningType $warnings = null, \dgsoft\StructType\DgSuccessType $success = null, \dgsoft\StructType\DgErrorsType $errors = null, $referenceNumber = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $resResponseType = null)
    {
        $this
            ->setVersion($version)
            ->setHotelPriceChangeInfo($hotelPriceChangeInfo)
            ->setPOS($pOS)
            ->setHotelReservations($hotelReservations)
            ->setWarnings($warnings)
            ->setSuccess($success)
            ->setErrors($errors)
            ->setReferenceNumber($referenceNumber)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setResResponseType($resResponseType);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get HotelPriceChangeInfo value
     * @return \dgsoft\StructType\DgHotelPriceChangeInfo|null
     */
    public function getHotelPriceChangeInfo()
    {
        return $this->HotelPriceChangeInfo;
    }
    /**
     * Set HotelPriceChangeInfo value
     * @param \dgsoft\StructType\DgHotelPriceChangeInfo $hotelPriceChangeInfo
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setHotelPriceChangeInfo(\dgsoft\StructType\DgHotelPriceChangeInfo $hotelPriceChangeInfo = null)
    {
        $this->HotelPriceChangeInfo = $hotelPriceChangeInfo;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get HotelReservations value
     * @return \dgsoft\StructType\DgHotelReservationsType|null
     */
    public function getHotelReservations()
    {
        return $this->HotelReservations;
    }
    /**
     * Set HotelReservations value
     * @param \dgsoft\StructType\DgHotelReservationsType $hotelReservations
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setHotelReservations(\dgsoft\StructType\DgHotelReservationsType $hotelReservations = null)
    {
        $this->HotelReservations = $hotelReservations;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \dgsoft\ArrayType\DgArrayOfWarningType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \dgsoft\ArrayType\DgArrayOfWarningType $warnings
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setWarnings(\dgsoft\ArrayType\DgArrayOfWarningType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Success value
     * @return \dgsoft\StructType\DgSuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \dgsoft\StructType\DgSuccessType $success
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setSuccess(\dgsoft\StructType\DgSuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get ResResponseType value
     * @return string|null
     */
    public function getResResponseType()
    {
        return $this->ResResponseType;
    }
    /**
     * Set ResResponseType value
     * @uses \dgsoft\EnumType\DgTransactionStatusType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTransactionStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resResponseType
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public function setResResponseType($resResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTransactionStatusType::valueIsValid($resResponseType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resResponseType, implode(', ', \dgsoft\EnumType\DgTransactionStatusType::getValidValues())), __LINE__);
        }
        $this->ResResponseType = $resResponseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_HotelResRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
