<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_CurrencyConversionRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_CurrencyConversionRQ extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The FromCurrency
     * @var string
     */
    public $FromCurrency;
    /**
     * The ToCurrency
     * @var string
     */
    public $ToCurrency;
    /**
     * Constructor method for OTA_CurrencyConversionRQ
     * @uses DgOTA_CurrencyConversionRQ::setAmount()
     * @uses DgOTA_CurrencyConversionRQ::setFromCurrency()
     * @uses DgOTA_CurrencyConversionRQ::setToCurrency()
     * @param float $amount
     * @param string $fromCurrency
     * @param string $toCurrency
     */
    public function __construct($amount = null, $fromCurrency = null, $toCurrency = null)
    {
        $this
            ->setAmount($amount)
            ->setFromCurrency($fromCurrency)
            ->setToCurrency($toCurrency);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgOTA_CurrencyConversionRQ
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get FromCurrency value
     * @return string|null
     */
    public function getFromCurrency()
    {
        return $this->FromCurrency;
    }
    /**
     * Set FromCurrency value
     * @param string $fromCurrency
     * @return \dgsoft\StructType\DgOTA_CurrencyConversionRQ
     */
    public function setFromCurrency($fromCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($fromCurrency) && !is_string($fromCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromCurrency)), __LINE__);
        }
        $this->FromCurrency = $fromCurrency;
        return $this;
    }
    /**
     * Get ToCurrency value
     * @return string|null
     */
    public function getToCurrency()
    {
        return $this->ToCurrency;
    }
    /**
     * Set ToCurrency value
     * @param string $toCurrency
     * @return \dgsoft\StructType\DgOTA_CurrencyConversionRQ
     */
    public function setToCurrency($toCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($toCurrency) && !is_string($toCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toCurrency)), __LINE__);
        }
        $this->ToCurrency = $toCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_CurrencyConversionRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
