<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_CancelRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_CancelRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The CancelType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CancelType;
    /**
     * The PNRNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PNRNo;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $BookingReferenceID;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID[]
     */
    public $UniqueID;
    /**
     * The Verification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVerificationType[]
     */
    public $Verification;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSegment[]
     */
    public $Segment;
    /**
     * The CancellationOverrides
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCancellationOverrides
     */
    public $CancellationOverrides;
    /**
     * The Reasons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFreeTextType
     */
    public $Reasons;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The ReqRespVersion
     * @var string
     */
    public $ReqRespVersion;
    /**
     * The TravelSector
     * @var string
     */
    public $TravelSector;
    /**
     * Constructor method for OTA_CancelRQ
     * @uses DgOTA_CancelRQ::setVersion()
     * @uses DgOTA_CancelRQ::setCancelType()
     * @uses DgOTA_CancelRQ::setPNRNo()
     * @uses DgOTA_CancelRQ::setBookingReferenceID()
     * @uses DgOTA_CancelRQ::setPOS()
     * @uses DgOTA_CancelRQ::setUniqueID()
     * @uses DgOTA_CancelRQ::setVerification()
     * @uses DgOTA_CancelRQ::setSegment()
     * @uses DgOTA_CancelRQ::setCancellationOverrides()
     * @uses DgOTA_CancelRQ::setReasons()
     * @uses DgOTA_CancelRQ::setTPA_Extensions()
     * @uses DgOTA_CancelRQ::setEchoToken()
     * @uses DgOTA_CancelRQ::setTimeStamp()
     * @uses DgOTA_CancelRQ::setTarget()
     * @uses DgOTA_CancelRQ::setTransactionIdentifier()
     * @uses DgOTA_CancelRQ::setSequenceNmbr()
     * @uses DgOTA_CancelRQ::setTransactionStatusCode()
     * @uses DgOTA_CancelRQ::setRetransmissionIndicator()
     * @uses DgOTA_CancelRQ::setReqRespVersion()
     * @uses DgOTA_CancelRQ::setTravelSector()
     * @param float $version
     * @param string $cancelType
     * @param string $pNRNo
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgUniqueID[] $uniqueID
     * @param \dgsoft\StructType\DgVerificationType[] $verification
     * @param \dgsoft\StructType\DgSegment[] $segment
     * @param \dgsoft\StructType\DgCancellationOverrides $cancellationOverrides
     * @param \dgsoft\ArrayType\DgArrayOfFreeTextType $reasons
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $reqRespVersion
     * @param string $travelSector
     */
    public function __construct($version = null, $cancelType = null, $pNRNo = null, \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, array $uniqueID = array(), array $verification = array(), array $segment = array(), \dgsoft\StructType\DgCancellationOverrides $cancellationOverrides = null, \dgsoft\ArrayType\DgArrayOfFreeTextType $reasons = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $reqRespVersion = null, $travelSector = null)
    {
        $this
            ->setVersion($version)
            ->setCancelType($cancelType)
            ->setPNRNo($pNRNo)
            ->setBookingReferenceID($bookingReferenceID)
            ->setPOS($pOS)
            ->setUniqueID($uniqueID)
            ->setVerification($verification)
            ->setSegment($segment)
            ->setCancellationOverrides($cancellationOverrides)
            ->setReasons($reasons)
            ->setTPA_Extensions($tPA_Extensions)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setReqRespVersion($reqRespVersion)
            ->setTravelSector($travelSector);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get CancelType value
     * @return string
     */
    public function getCancelType()
    {
        return $this->CancelType;
    }
    /**
     * Set CancelType value
     * @uses \dgsoft\EnumType\DgTransactionActionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cancelType
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setCancelType($cancelType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTransactionActionType::valueIsValid($cancelType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cancelType, implode(', ', \dgsoft\EnumType\DgTransactionActionType::getValidValues())), __LINE__);
        }
        $this->CancelType = $cancelType;
        return $this;
    }
    /**
     * Get PNRNo value
     * @return string|null
     */
    public function getPNRNo()
    {
        return $this->PNRNo;
    }
    /**
     * Set PNRNo value
     * @param string $pNRNo
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setPNRNo($pNRNo = null)
    {
        // validation for constraint: string
        if (!is_null($pNRNo) && !is_string($pNRNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pNRNo)), __LINE__);
        }
        $this->PNRNo = $pNRNo;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null)
    {
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \dgsoft\StructType\DgUniqueID[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID[] $uniqueID
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setUniqueID(array $uniqueID = array())
    {
        foreach ($uniqueID as $oTA_CancelRQUniqueIDItem) {
            // validation for constraint: itemType
            if (!$oTA_CancelRQUniqueIDItem instanceof \dgsoft\StructType\DgUniqueID) {
                throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of \dgsoft\StructType\DgUniqueID, "%s" given', is_object($oTA_CancelRQUniqueIDItem) ? get_class($oTA_CancelRQUniqueIDItem) : gettype($oTA_CancelRQUniqueIDItem)), __LINE__);
            }
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID $item
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function addToUniqueID(\dgsoft\StructType\DgUniqueID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of \dgsoft\StructType\DgUniqueID, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get Verification value
     * @return \dgsoft\StructType\DgVerificationType[]|null
     */
    public function getVerification()
    {
        return $this->Verification;
    }
    /**
     * Set Verification value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVerificationType[] $verification
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setVerification(array $verification = array())
    {
        foreach ($verification as $oTA_CancelRQVerificationItem) {
            // validation for constraint: itemType
            if (!$oTA_CancelRQVerificationItem instanceof \dgsoft\StructType\DgVerificationType) {
                throw new \InvalidArgumentException(sprintf('The Verification property can only contain items of \dgsoft\StructType\DgVerificationType, "%s" given', is_object($oTA_CancelRQVerificationItem) ? get_class($oTA_CancelRQVerificationItem) : gettype($oTA_CancelRQVerificationItem)), __LINE__);
            }
        }
        $this->Verification = $verification;
        return $this;
    }
    /**
     * Add item to Verification value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgVerificationType $item
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function addToVerification(\dgsoft\StructType\DgVerificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgVerificationType) {
            throw new \InvalidArgumentException(sprintf('The Verification property can only contain items of \dgsoft\StructType\DgVerificationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Verification[] = $item;
        return $this;
    }
    /**
     * Get Segment value
     * @return \dgsoft\StructType\DgSegment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSegment[] $segment
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setSegment(array $segment = array())
    {
        foreach ($segment as $oTA_CancelRQSegmentItem) {
            // validation for constraint: itemType
            if (!$oTA_CancelRQSegmentItem instanceof \dgsoft\StructType\DgSegment) {
                throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of \dgsoft\StructType\DgSegment, "%s" given', is_object($oTA_CancelRQSegmentItem) ? get_class($oTA_CancelRQSegmentItem) : gettype($oTA_CancelRQSegmentItem)), __LINE__);
            }
        }
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSegment $item
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function addToSegment(\dgsoft\StructType\DgSegment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSegment) {
            throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of \dgsoft\StructType\DgSegment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Segment[] = $item;
        return $this;
    }
    /**
     * Get CancellationOverrides value
     * @return \dgsoft\StructType\DgCancellationOverrides|null
     */
    public function getCancellationOverrides()
    {
        return $this->CancellationOverrides;
    }
    /**
     * Set CancellationOverrides value
     * @param \dgsoft\StructType\DgCancellationOverrides $cancellationOverrides
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setCancellationOverrides(\dgsoft\StructType\DgCancellationOverrides $cancellationOverrides = null)
    {
        $this->CancellationOverrides = $cancellationOverrides;
        return $this;
    }
    /**
     * Get Reasons value
     * @return \dgsoft\ArrayType\DgArrayOfFreeTextType|null
     */
    public function getReasons()
    {
        return $this->Reasons;
    }
    /**
     * Set Reasons value
     * @param \dgsoft\ArrayType\DgArrayOfFreeTextType $reasons
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setReasons(\dgsoft\ArrayType\DgArrayOfFreeTextType $reasons = null)
    {
        $this->Reasons = $reasons;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get ReqRespVersion value
     * @return string|null
     */
    public function getReqRespVersion()
    {
        return $this->ReqRespVersion;
    }
    /**
     * Set ReqRespVersion value
     * @param string $reqRespVersion
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setReqRespVersion($reqRespVersion = null)
    {
        // validation for constraint: string
        if (!is_null($reqRespVersion) && !is_string($reqRespVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqRespVersion)), __LINE__);
        }
        $this->ReqRespVersion = $reqRespVersion;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_CancelRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
