<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirSeatMapRQAirTravelerCustLoyalty StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirSeatMapRQAirTravelerCustLoyalty extends AbstractStructBase
{
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The TravelSector
     * @var string
     */
    public $TravelSector;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The VendorCode
     * @var string[]
     */
    public $VendorCode;
    /**
     * Constructor method for OTA_AirSeatMapRQAirTravelerCustLoyalty
     * @uses DgOTA_AirSeatMapRQAirTravelerCustLoyalty::setProgramID()
     * @uses DgOTA_AirSeatMapRQAirTravelerCustLoyalty::setMembershipID()
     * @uses DgOTA_AirSeatMapRQAirTravelerCustLoyalty::setTravelSector()
     * @uses DgOTA_AirSeatMapRQAirTravelerCustLoyalty::setRPH()
     * @uses DgOTA_AirSeatMapRQAirTravelerCustLoyalty::setVendorCode()
     * @param string $programID
     * @param string $membershipID
     * @param string $travelSector
     * @param string $rPH
     * @param string[] $vendorCode
     */
    public function __construct($programID = null, $membershipID = null, $travelSector = null, $rPH = null, array $vendorCode = array())
    {
        $this
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setTravelSector($travelSector)
            ->setRPH($rPH)
            ->setVendorCode($vendorCode);
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQAirTravelerCustLoyalty
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQAirTravelerCustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQAirTravelerCustLoyalty
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQAirTravelerCustLoyalty
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string[]|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $vendorCode
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQAirTravelerCustLoyalty
     */
    public function setVendorCode(array $vendorCode = array())
    {
        foreach ($vendorCode as $oTA_AirSeatMapRQAirTravelerCustLoyaltyVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($oTA_AirSeatMapRQAirTravelerCustLoyaltyVendorCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of string, "%s" given', is_object($oTA_AirSeatMapRQAirTravelerCustLoyaltyVendorCodeItem) ? get_class($oTA_AirSeatMapRQAirTravelerCustLoyaltyVendorCodeItem) : gettype($oTA_AirSeatMapRQAirTravelerCustLoyaltyVendorCodeItem)), __LINE__);
            }
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Add item to VendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQAirTravelerCustLoyalty
     */
    public function addToVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQAirTravelerCustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
