<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirScheduleRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirScheduleRQ extends AbstractStructBase
{
    /**
     * The MoreResults
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $MoreResults;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The OriginDestinationInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOriginDestinationInformationType
     */
    public $OriginDestinationInformation;
    /**
     * The FlightInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public $FlightInfo;
    /**
     * The VendorPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNamePrefType[]
     */
    public $VendorPref;
    /**
     * The FlightTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The EquipPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The MaxResponses
     * @var int
     */
    public $MaxResponses;
    /**
     * Constructor method for OTA_AirScheduleRQ
     * @uses DgOTA_AirScheduleRQ::setMoreResults()
     * @uses DgOTA_AirScheduleRQ::setVersion()
     * @uses DgOTA_AirScheduleRQ::setPOS()
     * @uses DgOTA_AirScheduleRQ::setOriginDestinationInformation()
     * @uses DgOTA_AirScheduleRQ::setFlightInfo()
     * @uses DgOTA_AirScheduleRQ::setVendorPref()
     * @uses DgOTA_AirScheduleRQ::setFlightTypePref()
     * @uses DgOTA_AirScheduleRQ::setEquipPref()
     * @uses DgOTA_AirScheduleRQ::setEchoToken()
     * @uses DgOTA_AirScheduleRQ::setTimeStamp()
     * @uses DgOTA_AirScheduleRQ::setTarget()
     * @uses DgOTA_AirScheduleRQ::setTransactionIdentifier()
     * @uses DgOTA_AirScheduleRQ::setSequenceNmbr()
     * @uses DgOTA_AirScheduleRQ::setTransactionStatusCode()
     * @uses DgOTA_AirScheduleRQ::setRetransmissionIndicator()
     * @uses DgOTA_AirScheduleRQ::setMaxResponses()
     * @param bool $moreResults
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgOriginDestinationInformationType $originDestinationInformation
     * @param \dgsoft\StructType\DgSpecificFlightInfoType $flightInfo
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $vendorPref
     * @param \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref[] $flightTypePref
     * @param \dgsoft\StructType\DgEquipmentTypePref[] $equipPref
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param int $maxResponses
     */
    public function __construct($moreResults = null, $version = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\StructType\DgOriginDestinationInformationType $originDestinationInformation = null, \dgsoft\StructType\DgSpecificFlightInfoType $flightInfo = null, array $vendorPref = array(), array $flightTypePref = array(), array $equipPref = array(), $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $maxResponses = null)
    {
        $this
            ->setMoreResults($moreResults)
            ->setVersion($version)
            ->setPOS($pOS)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setFlightInfo($flightInfo)
            ->setVendorPref($vendorPref)
            ->setFlightTypePref($flightTypePref)
            ->setEquipPref($equipPref)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setMaxResponses($maxResponses);
    }
    /**
     * Get MoreResults value
     * @return bool
     */
    public function getMoreResults()
    {
        return $this->MoreResults;
    }
    /**
     * Set MoreResults value
     * @param bool $moreResults
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setMoreResults($moreResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreResults) && !is_bool($moreResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreResults)), __LINE__);
        }
        $this->MoreResults = $moreResults;
        return $this;
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \dgsoft\StructType\DgOriginDestinationInformationType|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @param \dgsoft\StructType\DgOriginDestinationInformationType $originDestinationInformation
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setOriginDestinationInformation(\dgsoft\StructType\DgOriginDestinationInformationType $originDestinationInformation = null)
    {
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Get FlightInfo value
     * @return \dgsoft\StructType\DgSpecificFlightInfoType|null
     */
    public function getFlightInfo()
    {
        return $this->FlightInfo;
    }
    /**
     * Set FlightInfo value
     * @param \dgsoft\StructType\DgSpecificFlightInfoType $flightInfo
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setFlightInfo(\dgsoft\StructType\DgSpecificFlightInfoType $flightInfo = null)
    {
        $this->FlightInfo = $flightInfo;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \dgsoft\StructType\DgCompanyNamePrefType[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $vendorPref
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setVendorPref(array $vendorPref = array())
    {
        foreach ($vendorPref as $oTA_AirScheduleRQVendorPrefItem) {
            // validation for constraint: itemType
            if (!$oTA_AirScheduleRQVendorPrefItem instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($oTA_AirScheduleRQVendorPrefItem) ? get_class($oTA_AirScheduleRQVendorPrefItem) : gettype($oTA_AirScheduleRQVendorPrefItem)), __LINE__);
            }
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType $item
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function addToVendorPref(\dgsoft\StructType\DgCompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref[] $flightTypePref
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        foreach ($flightTypePref as $oTA_AirScheduleRQFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$oTA_AirScheduleRQFlightTypePrefItem instanceof \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref) {
                throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref, "%s" given', is_object($oTA_AirScheduleRQFlightTypePrefItem) ? get_class($oTA_AirScheduleRQFlightTypePrefItem) : gettype($oTA_AirScheduleRQFlightTypePrefItem)), __LINE__);
            }
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref $item
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function addToFlightTypePref(\dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of \dgsoft\StructType\DgOTA_AirScheduleRQFlightTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \dgsoft\StructType\DgEquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEquipmentTypePref[] $equipPref
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setEquipPref(array $equipPref = array())
    {
        foreach ($equipPref as $oTA_AirScheduleRQEquipPrefItem) {
            // validation for constraint: itemType
            if (!$oTA_AirScheduleRQEquipPrefItem instanceof \dgsoft\StructType\DgEquipmentTypePref) {
                throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \dgsoft\StructType\DgEquipmentTypePref, "%s" given', is_object($oTA_AirScheduleRQEquipPrefItem) ? get_class($oTA_AirScheduleRQEquipPrefItem) : gettype($oTA_AirScheduleRQEquipPrefItem)), __LINE__);
            }
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEquipmentTypePref $item
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function addToEquipPref(\dgsoft\StructType\DgEquipmentTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEquipmentTypePref) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of \dgsoft\StructType\DgEquipmentTypePref, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_AirScheduleRQTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_AirScheduleRQTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_AirScheduleRQTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_AirScheduleRQTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_AirScheduleRQTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_AirScheduleRQTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_AirScheduleRQTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_AirScheduleRQTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return int|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param int $maxResponses
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        // validation for constraint: int
        if (!is_null($maxResponses) && !is_numeric($maxResponses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResponses)), __LINE__);
        }
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirScheduleRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
