<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirBookRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirBookRS extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The NewPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public $NewPrice;
    /**
     * The Failback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFailbackRS
     */
    public $Failback;
    /**
     * The OldPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public $OldPrice;
    /**
     * The AirReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirReservation
     */
    public $AirReservation;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgWarningsType
     */
    public $Warnings;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSuccessType
     */
    public $Success;
    /**
     * The BookingToBeCancelled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBookingToBeCancelled
     */
    public $BookingToBeCancelled;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The PaymentRequestURL
     * @var string
     */
    public $PaymentRequestURL;
    /**
     * The Cancel
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $Cancel;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The PriceInd
     * @var bool
     */
    public $PriceInd;
    /**
     * The InsuranceReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS
     */
    public $InsuranceReservation;
    /**
     * The HotelReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_HotelResRS
     */
    public $HotelReservation;
    /**
     * The CarReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehResRS
     */
    public $CarReservation;
    /**
     * The TravelerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerInfoType
     */
    public $TravelerInfo;
    /**
     * The FullFilment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFullFilment
     */
    public $FullFilment;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * Constructor method for OTA_AirBookRS
     * @uses DgOTA_AirBookRS::setVersion()
     * @uses DgOTA_AirBookRS::setNewPrice()
     * @uses DgOTA_AirBookRS::setFailback()
     * @uses DgOTA_AirBookRS::setOldPrice()
     * @uses DgOTA_AirBookRS::setAirReservation()
     * @uses DgOTA_AirBookRS::setErrors()
     * @uses DgOTA_AirBookRS::setWarnings()
     * @uses DgOTA_AirBookRS::setSuccess()
     * @uses DgOTA_AirBookRS::setBookingToBeCancelled()
     * @uses DgOTA_AirBookRS::setReferenceNumber()
     * @uses DgOTA_AirBookRS::setPaymentRequestURL()
     * @uses DgOTA_AirBookRS::setCancel()
     * @uses DgOTA_AirBookRS::setEchoToken()
     * @uses DgOTA_AirBookRS::setTimeStamp()
     * @uses DgOTA_AirBookRS::setTarget()
     * @uses DgOTA_AirBookRS::setTransactionIdentifier()
     * @uses DgOTA_AirBookRS::setSequenceNmbr()
     * @uses DgOTA_AirBookRS::setTransactionStatusCode()
     * @uses DgOTA_AirBookRS::setRetransmissionIndicator()
     * @uses DgOTA_AirBookRS::setPriceInd()
     * @uses DgOTA_AirBookRS::setInsuranceReservation()
     * @uses DgOTA_AirBookRS::setHotelReservation()
     * @uses DgOTA_AirBookRS::setCarReservation()
     * @uses DgOTA_AirBookRS::setTravelerInfo()
     * @uses DgOTA_AirBookRS::setFullFilment()
     * @uses DgOTA_AirBookRS::setBookingReferenceID()
     * @param float $version
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice
     * @param \dgsoft\StructType\DgFailbackRS $failback
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $oldPrice
     * @param \dgsoft\StructType\DgAirReservation $airReservation
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @param \dgsoft\StructType\DgSuccessType $success
     * @param \dgsoft\StructType\DgBookingToBeCancelled $bookingToBeCancelled
     * @param string $referenceNumber
     * @param string $paymentRequestURL
     * @param bool $cancel
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param bool $priceInd
     * @param \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS $insuranceReservation
     * @param \dgsoft\StructType\DgOTA_HotelResRS $hotelReservation
     * @param \dgsoft\StructType\DgOTA_VehResRS $carReservation
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @param \dgsoft\StructType\DgFullFilment $fullFilment
     * @param \dgsoft\StructType\DgUniqueID_Type[] $bookingReferenceID
     */
    public function __construct($version = null, \dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice = null, \dgsoft\StructType\DgFailbackRS $failback = null, \dgsoft\StructType\DgAirItineraryPricingInfoType $oldPrice = null, \dgsoft\StructType\DgAirReservation $airReservation = null, \dgsoft\StructType\DgErrorsType $errors = null, \dgsoft\StructType\DgWarningsType $warnings = null, \dgsoft\StructType\DgSuccessType $success = null, \dgsoft\StructType\DgBookingToBeCancelled $bookingToBeCancelled = null, $referenceNumber = null, $paymentRequestURL = null, $cancel = false, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $priceInd = null, \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS $insuranceReservation = null, \dgsoft\StructType\DgOTA_HotelResRS $hotelReservation = null, \dgsoft\StructType\DgOTA_VehResRS $carReservation = null, \dgsoft\StructType\DgTravelerInfoType $travelerInfo = null, \dgsoft\StructType\DgFullFilment $fullFilment = null, array $bookingReferenceID = array())
    {
        $this
            ->setVersion($version)
            ->setNewPrice($newPrice)
            ->setFailback($failback)
            ->setOldPrice($oldPrice)
            ->setAirReservation($airReservation)
            ->setErrors($errors)
            ->setWarnings($warnings)
            ->setSuccess($success)
            ->setBookingToBeCancelled($bookingToBeCancelled)
            ->setReferenceNumber($referenceNumber)
            ->setPaymentRequestURL($paymentRequestURL)
            ->setCancel($cancel)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setPriceInd($priceInd)
            ->setInsuranceReservation($insuranceReservation)
            ->setHotelReservation($hotelReservation)
            ->setCarReservation($carReservation)
            ->setTravelerInfo($travelerInfo)
            ->setFullFilment($fullFilment)
            ->setBookingReferenceID($bookingReferenceID);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get NewPrice value
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType|null
     */
    public function getNewPrice()
    {
        return $this->NewPrice;
    }
    /**
     * Set NewPrice value
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setNewPrice(\dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice = null)
    {
        $this->NewPrice = $newPrice;
        return $this;
    }
    /**
     * Get Failback value
     * @return \dgsoft\StructType\DgFailbackRS|null
     */
    public function getFailback()
    {
        return $this->Failback;
    }
    /**
     * Set Failback value
     * @param \dgsoft\StructType\DgFailbackRS $failback
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setFailback(\dgsoft\StructType\DgFailbackRS $failback = null)
    {
        $this->Failback = $failback;
        return $this;
    }
    /**
     * Get OldPrice value
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType|null
     */
    public function getOldPrice()
    {
        return $this->OldPrice;
    }
    /**
     * Set OldPrice value
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $oldPrice
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setOldPrice(\dgsoft\StructType\DgAirItineraryPricingInfoType $oldPrice = null)
    {
        $this->OldPrice = $oldPrice;
        return $this;
    }
    /**
     * Get AirReservation value
     * @return \dgsoft\StructType\DgAirReservation|null
     */
    public function getAirReservation()
    {
        return $this->AirReservation;
    }
    /**
     * Set AirReservation value
     * @param \dgsoft\StructType\DgAirReservation $airReservation
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setAirReservation(\dgsoft\StructType\DgAirReservation $airReservation = null)
    {
        $this->AirReservation = $airReservation;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \dgsoft\StructType\DgWarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setWarnings(\dgsoft\StructType\DgWarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Success value
     * @return \dgsoft\StructType\DgSuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \dgsoft\StructType\DgSuccessType $success
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setSuccess(\dgsoft\StructType\DgSuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get BookingToBeCancelled value
     * @return \dgsoft\StructType\DgBookingToBeCancelled|null
     */
    public function getBookingToBeCancelled()
    {
        return $this->BookingToBeCancelled;
    }
    /**
     * Set BookingToBeCancelled value
     * @param \dgsoft\StructType\DgBookingToBeCancelled $bookingToBeCancelled
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setBookingToBeCancelled(\dgsoft\StructType\DgBookingToBeCancelled $bookingToBeCancelled = null)
    {
        $this->BookingToBeCancelled = $bookingToBeCancelled;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get PaymentRequestURL value
     * @return string|null
     */
    public function getPaymentRequestURL()
    {
        return $this->PaymentRequestURL;
    }
    /**
     * Set PaymentRequestURL value
     * @param string $paymentRequestURL
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setPaymentRequestURL($paymentRequestURL = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRequestURL) && !is_string($paymentRequestURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentRequestURL)), __LINE__);
        }
        $this->PaymentRequestURL = $paymentRequestURL;
        return $this;
    }
    /**
     * Get Cancel value
     * @return bool|null
     */
    public function getCancel()
    {
        return $this->Cancel;
    }
    /**
     * Set Cancel value
     * @param bool $cancel
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setCancel($cancel = false)
    {
        // validation for constraint: boolean
        if (!is_null($cancel) && !is_bool($cancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancel)), __LINE__);
        }
        $this->Cancel = $cancel;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get PriceInd value
     * @return bool|null
     */
    public function getPriceInd()
    {
        return $this->PriceInd;
    }
    /**
     * Set PriceInd value
     * @param bool $priceInd
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setPriceInd($priceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceInd) && !is_bool($priceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priceInd)), __LINE__);
        }
        $this->PriceInd = $priceInd;
        return $this;
    }
    /**
     * Get InsuranceReservation value
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS|null
     */
    public function getInsuranceReservation()
    {
        return $this->InsuranceReservation;
    }
    /**
     * Set InsuranceReservation value
     * @param \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS $insuranceReservation
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setInsuranceReservation(\dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS $insuranceReservation = null)
    {
        $this->InsuranceReservation = $insuranceReservation;
        return $this;
    }
    /**
     * Get HotelReservation value
     * @return \dgsoft\StructType\DgOTA_HotelResRS|null
     */
    public function getHotelReservation()
    {
        return $this->HotelReservation;
    }
    /**
     * Set HotelReservation value
     * @param \dgsoft\StructType\DgOTA_HotelResRS $hotelReservation
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setHotelReservation(\dgsoft\StructType\DgOTA_HotelResRS $hotelReservation = null)
    {
        $this->HotelReservation = $hotelReservation;
        return $this;
    }
    /**
     * Get CarReservation value
     * @return \dgsoft\StructType\DgOTA_VehResRS|null
     */
    public function getCarReservation()
    {
        return $this->CarReservation;
    }
    /**
     * Set CarReservation value
     * @param \dgsoft\StructType\DgOTA_VehResRS $carReservation
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setCarReservation(\dgsoft\StructType\DgOTA_VehResRS $carReservation = null)
    {
        $this->CarReservation = $carReservation;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return \dgsoft\StructType\DgTravelerInfoType|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setTravelerInfo(\dgsoft\StructType\DgTravelerInfoType $travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get FullFilment value
     * @return \dgsoft\StructType\DgFullFilment|null
     */
    public function getFullFilment()
    {
        return $this->FullFilment;
    }
    /**
     * Set FullFilment value
     * @param \dgsoft\StructType\DgFullFilment $fullFilment
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setFullFilment(\dgsoft\StructType\DgFullFilment $fullFilment = null)
    {
        $this->FullFilment = $fullFilment;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $bookingReferenceID
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $oTA_AirBookRSBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$oTA_AirBookRSBookingReferenceIDItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($oTA_AirBookRSBookingReferenceIDItem) ? get_class($oTA_AirBookRSBookingReferenceIDItem) : gettype($oTA_AirBookRSBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public function addToBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirBookRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
