<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirBookRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirBookRQ extends DgGenericFlightRQ
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The PNRRemarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo
     */
    public $PNRRemarks;
    /**
     * The AirItineraryPricingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public $AirItineraryPricingInfo;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The AirItinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryType
     */
    public $AirItinerary;
    /**
     * The PriceInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPriceInfo
     */
    public $PriceInfo;
    /**
     * The TravelerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerInfoType
     */
    public $TravelerInfo;
    /**
     * The Fulfillment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFulfillment
     */
    public $Fulfillment;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketing[]
     */
    public $Ticketing;
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueue
     */
    public $Queue;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $BookingReferenceID;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The InsurancePlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInsurancePlan
     */
    public $InsurancePlan;
    /**
     * The RelatedMember
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRelatedMember
     */
    public $RelatedMember;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The ControlNumber
     * @var string
     */
    public $ControlNumber;
    /**
     * The CorporatePinNumber
     * @var string
     */
    public $CorporatePinNumber;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * The PriceInd
     * @var bool
     */
    public $PriceInd;
    /**
     * Constructor method for OTA_AirBookRQ
     * @uses DgOTA_AirBookRQ::setVersion()
     * @uses DgOTA_AirBookRQ::setPNRRemarks()
     * @uses DgOTA_AirBookRQ::setAirItineraryPricingInfo()
     * @uses DgOTA_AirBookRQ::setPOS()
     * @uses DgOTA_AirBookRQ::setAirItinerary()
     * @uses DgOTA_AirBookRQ::setPriceInfo()
     * @uses DgOTA_AirBookRQ::setTravelerInfo()
     * @uses DgOTA_AirBookRQ::setFulfillment()
     * @uses DgOTA_AirBookRQ::setTicketing()
     * @uses DgOTA_AirBookRQ::setQueue()
     * @uses DgOTA_AirBookRQ::setBookingReferenceID()
     * @uses DgOTA_AirBookRQ::setTPA_Extensions()
     * @uses DgOTA_AirBookRQ::setInsurancePlan()
     * @uses DgOTA_AirBookRQ::setRelatedMember()
     * @uses DgOTA_AirBookRQ::setReferenceNumber()
     * @uses DgOTA_AirBookRQ::setControlNumber()
     * @uses DgOTA_AirBookRQ::setCorporatePinNumber()
     * @uses DgOTA_AirBookRQ::setEchoToken()
     * @uses DgOTA_AirBookRQ::setTimeStamp()
     * @uses DgOTA_AirBookRQ::setTarget()
     * @uses DgOTA_AirBookRQ::setTransactionIdentifier()
     * @uses DgOTA_AirBookRQ::setSequenceNmbr()
     * @uses DgOTA_AirBookRQ::setTransactionStatusCode()
     * @uses DgOTA_AirBookRQ::setRetransmissionIndicator()
     * @uses DgOTA_AirBookRQ::setResStatus()
     * @uses DgOTA_AirBookRQ::setPriceInd()
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $airItineraryPricingInfo
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgAirItineraryType $airItinerary
     * @param \dgsoft\StructType\DgPriceInfo $priceInfo
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @param \dgsoft\StructType\DgFulfillment $fulfillment
     * @param \dgsoft\StructType\DgTicketing[] $ticketing
     * @param \dgsoft\StructType\DgQueue $queue
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param \dgsoft\StructType\DgInsurancePlan $insurancePlan
     * @param \dgsoft\StructType\DgRelatedMember $relatedMember
     * @param string $referenceNumber
     * @param string $controlNumber
     * @param string $corporatePinNumber
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $resStatus
     * @param bool $priceInd
     */
    public function __construct($version = null, \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks = null, \dgsoft\StructType\DgAirItineraryPricingInfoType $airItineraryPricingInfo = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\StructType\DgAirItineraryType $airItinerary = null, \dgsoft\StructType\DgPriceInfo $priceInfo = null, \dgsoft\StructType\DgTravelerInfoType $travelerInfo = null, \dgsoft\StructType\DgFulfillment $fulfillment = null, array $ticketing = array(), \dgsoft\StructType\DgQueue $queue = null, \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, \dgsoft\StructType\DgInsurancePlan $insurancePlan = null, \dgsoft\StructType\DgRelatedMember $relatedMember = null, $referenceNumber = null, $controlNumber = null, $corporatePinNumber = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $resStatus = null, $priceInd = null)
    {
        $this
            ->setVersion($version)
            ->setPNRRemarks($pNRRemarks)
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setPOS($pOS)
            ->setAirItinerary($airItinerary)
            ->setPriceInfo($priceInfo)
            ->setTravelerInfo($travelerInfo)
            ->setFulfillment($fulfillment)
            ->setTicketing($ticketing)
            ->setQueue($queue)
            ->setBookingReferenceID($bookingReferenceID)
            ->setTPA_Extensions($tPA_Extensions)
            ->setInsurancePlan($insurancePlan)
            ->setRelatedMember($relatedMember)
            ->setReferenceNumber($referenceNumber)
            ->setControlNumber($controlNumber)
            ->setCorporatePinNumber($corporatePinNumber)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setResStatus($resStatus)
            ->setPriceInd($priceInd);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get PNRRemarks value
     * @return \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo|null
     */
    public function getPNRRemarks()
    {
        return $this->PNRRemarks;
    }
    /**
     * Set PNRRemarks value
     * @param \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setPNRRemarks(\dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks = null)
    {
        $this->PNRRemarks = $pNRRemarks;
        return $this;
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $airItineraryPricingInfo
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setAirItineraryPricingInfo(\dgsoft\StructType\DgAirItineraryPricingInfoType $airItineraryPricingInfo = null)
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get AirItinerary value
     * @return \dgsoft\StructType\DgAirItineraryType|null
     */
    public function getAirItinerary()
    {
        return $this->AirItinerary;
    }
    /**
     * Set AirItinerary value
     * @param \dgsoft\StructType\DgAirItineraryType $airItinerary
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setAirItinerary(\dgsoft\StructType\DgAirItineraryType $airItinerary = null)
    {
        $this->AirItinerary = $airItinerary;
        return $this;
    }
    /**
     * Get PriceInfo value
     * @return \dgsoft\StructType\DgPriceInfo|null
     */
    public function getPriceInfo()
    {
        return $this->PriceInfo;
    }
    /**
     * Set PriceInfo value
     * @param \dgsoft\StructType\DgPriceInfo $priceInfo
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setPriceInfo(\dgsoft\StructType\DgPriceInfo $priceInfo = null)
    {
        $this->PriceInfo = $priceInfo;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return \dgsoft\StructType\DgTravelerInfoType|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setTravelerInfo(\dgsoft\StructType\DgTravelerInfoType $travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get Fulfillment value
     * @return \dgsoft\StructType\DgFulfillment|null
     */
    public function getFulfillment()
    {
        return $this->Fulfillment;
    }
    /**
     * Set Fulfillment value
     * @param \dgsoft\StructType\DgFulfillment $fulfillment
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setFulfillment(\dgsoft\StructType\DgFulfillment $fulfillment = null)
    {
        $this->Fulfillment = $fulfillment;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \dgsoft\StructType\DgTicketing[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketing[] $ticketing
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setTicketing(array $ticketing = array())
    {
        foreach ($ticketing as $oTA_AirBookRQTicketingItem) {
            // validation for constraint: itemType
            if (!$oTA_AirBookRQTicketingItem instanceof \dgsoft\StructType\DgTicketing) {
                throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of \dgsoft\StructType\DgTicketing, "%s" given', is_object($oTA_AirBookRQTicketingItem) ? get_class($oTA_AirBookRQTicketingItem) : gettype($oTA_AirBookRQTicketingItem)), __LINE__);
            }
        }
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketing $item
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function addToTicketing(\dgsoft\StructType\DgTicketing $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTicketing) {
            throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of \dgsoft\StructType\DgTicketing, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Get Queue value
     * @return \dgsoft\StructType\DgQueue|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @param \dgsoft\StructType\DgQueue $queue
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setQueue(\dgsoft\StructType\DgQueue $queue = null)
    {
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null)
    {
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get InsurancePlan value
     * @return \dgsoft\StructType\DgInsurancePlan|null
     */
    public function getInsurancePlan()
    {
        return $this->InsurancePlan;
    }
    /**
     * Set InsurancePlan value
     * @param \dgsoft\StructType\DgInsurancePlan $insurancePlan
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setInsurancePlan(\dgsoft\StructType\DgInsurancePlan $insurancePlan = null)
    {
        $this->InsurancePlan = $insurancePlan;
        return $this;
    }
    /**
     * Get RelatedMember value
     * @return \dgsoft\StructType\DgRelatedMember|null
     */
    public function getRelatedMember()
    {
        return $this->RelatedMember;
    }
    /**
     * Set RelatedMember value
     * @param \dgsoft\StructType\DgRelatedMember $relatedMember
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setRelatedMember(\dgsoft\StructType\DgRelatedMember $relatedMember = null)
    {
        $this->RelatedMember = $relatedMember;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ControlNumber value
     * @return string|null
     */
    public function getControlNumber()
    {
        return $this->ControlNumber;
    }
    /**
     * Set ControlNumber value
     * @param string $controlNumber
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setControlNumber($controlNumber = null)
    {
        // validation for constraint: string
        if (!is_null($controlNumber) && !is_string($controlNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controlNumber)), __LINE__);
        }
        $this->ControlNumber = $controlNumber;
        return $this;
    }
    /**
     * Get CorporatePinNumber value
     * @return string|null
     */
    public function getCorporatePinNumber()
    {
        return $this->CorporatePinNumber;
    }
    /**
     * Set CorporatePinNumber value
     * @param string $corporatePinNumber
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setCorporatePinNumber($corporatePinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($corporatePinNumber) && !is_string($corporatePinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corporatePinNumber)), __LINE__);
        }
        $this->CorporatePinNumber = $corporatePinNumber;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @uses \dgsoft\EnumType\DgTransactionActionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resStatus
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTransactionActionType::valueIsValid($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resStatus, implode(', ', \dgsoft\EnumType\DgTransactionActionType::getValidValues())), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Get PriceInd value
     * @return bool|null
     */
    public function getPriceInd()
    {
        return $this->PriceInd;
    }
    /**
     * Set PriceInd value
     * @param bool $priceInd
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public function setPriceInd($priceInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceInd) && !is_bool($priceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priceInd)), __LINE__);
        }
        $this->PriceInd = $priceInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirBookRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
