<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OSIElementChange StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOSIElementChange extends AbstractStructBase
{
    /**
     * The ChangeDetailAction
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ChangeDetailAction;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $PersonName;
    /**
     * The OSIMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OSIMessage;
    /**
     * Constructor method for OSIElementChange
     * @uses DgOSIElementChange::setChangeDetailAction()
     * @uses DgOSIElementChange::setPersonName()
     * @uses DgOSIElementChange::setOSIMessage()
     * @param string $changeDetailAction
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @param string $oSIMessage
     */
    public function __construct($changeDetailAction = null, \dgsoft\StructType\DgPersonNameType $personName = null, $oSIMessage = null)
    {
        $this
            ->setChangeDetailAction($changeDetailAction)
            ->setPersonName($personName)
            ->setOSIMessage($oSIMessage);
    }
    /**
     * Get ChangeDetailAction value
     * @return string
     */
    public function getChangeDetailAction()
    {
        return $this->ChangeDetailAction;
    }
    /**
     * Set ChangeDetailAction value
     * @uses \dgsoft\EnumType\DgChangeDetailActionTypes::valueIsValid()
     * @uses \dgsoft\EnumType\DgChangeDetailActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changeDetailAction
     * @return \dgsoft\StructType\DgOSIElementChange
     */
    public function setChangeDetailAction($changeDetailAction = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgChangeDetailActionTypes::valueIsValid($changeDetailAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $changeDetailAction, implode(', ', \dgsoft\EnumType\DgChangeDetailActionTypes::getValidValues())), __LINE__);
        }
        $this->ChangeDetailAction = $changeDetailAction;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @return \dgsoft\StructType\DgOSIElementChange
     */
    public function setPersonName(\dgsoft\StructType\DgPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get OSIMessage value
     * @return string|null
     */
    public function getOSIMessage()
    {
        return $this->OSIMessage;
    }
    /**
     * Set OSIMessage value
     * @param string $oSIMessage
     * @return \dgsoft\StructType\DgOSIElementChange
     */
    public function setOSIMessage($oSIMessage = null)
    {
        // validation for constraint: string
        if (!is_null($oSIMessage) && !is_string($oSIMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oSIMessage)), __LINE__);
        }
        $this->OSIMessage = $oSIMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOSIElementChange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
