<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NegotiatedFareCode StructType
 * @package Dg
 * @subpackage Structs
 */
class DgNegotiatedFareCode extends AbstractStructBase
{
    /**
     * The SecondaryCode
     * @var string
     */
    public $SecondaryCode;
    /**
     * The SupplierCode
     * @var string
     */
    public $SupplierCode;
    /**
     * The Value
     * @var string
     */
    public $Value;
    /**
     * Constructor method for NegotiatedFareCode
     * @uses DgNegotiatedFareCode::setSecondaryCode()
     * @uses DgNegotiatedFareCode::setSupplierCode()
     * @uses DgNegotiatedFareCode::setValue()
     * @param string $secondaryCode
     * @param string $supplierCode
     * @param string $value
     */
    public function __construct($secondaryCode = null, $supplierCode = null, $value = null)
    {
        $this
            ->setSecondaryCode($secondaryCode)
            ->setSupplierCode($supplierCode)
            ->setValue($value);
    }
    /**
     * Get SecondaryCode value
     * @return string|null
     */
    public function getSecondaryCode()
    {
        return $this->SecondaryCode;
    }
    /**
     * Set SecondaryCode value
     * @param string $secondaryCode
     * @return \dgsoft\StructType\DgNegotiatedFareCode
     */
    public function setSecondaryCode($secondaryCode = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryCode) && !is_string($secondaryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryCode)), __LINE__);
        }
        $this->SecondaryCode = $secondaryCode;
        return $this;
    }
    /**
     * Get SupplierCode value
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param string $supplierCode
     * @return \dgsoft\StructType\DgNegotiatedFareCode
     */
    public function setSupplierCode($supplierCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierCode) && !is_string($supplierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($supplierCode)), __LINE__);
        }
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \dgsoft\StructType\DgNegotiatedFareCode
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgNegotiatedFareCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
