<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultimediaDescriptionType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgMultimediaDescriptionType extends AbstractStructBase
{
    /**
     * The ImageItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfImageItemsTypeImageItem
     */
    public $ImageItems;
    /**
     * The VideoItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfVideoItemsTypeVideoItem
     */
    public $VideoItems;
    /**
     * The TextItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfTextItemsTypeTextItem
     */
    public $TextItems;
    /**
     * The InfoCode
     * @var string
     */
    public $InfoCode;
    /**
     * The AdditionalDetailCode
     * @var string
     */
    public $AdditionalDetailCode;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for MultimediaDescriptionType
     * @uses DgMultimediaDescriptionType::setImageItems()
     * @uses DgMultimediaDescriptionType::setVideoItems()
     * @uses DgMultimediaDescriptionType::setTextItems()
     * @uses DgMultimediaDescriptionType::setInfoCode()
     * @uses DgMultimediaDescriptionType::setAdditionalDetailCode()
     * @uses DgMultimediaDescriptionType::setID()
     * @param \dgsoft\ArrayType\DgArrayOfImageItemsTypeImageItem $imageItems
     * @param \dgsoft\ArrayType\DgArrayOfVideoItemsTypeVideoItem $videoItems
     * @param \dgsoft\ArrayType\DgArrayOfTextItemsTypeTextItem $textItems
     * @param string $infoCode
     * @param string $additionalDetailCode
     * @param string $iD
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfImageItemsTypeImageItem $imageItems = null, \dgsoft\ArrayType\DgArrayOfVideoItemsTypeVideoItem $videoItems = null, \dgsoft\ArrayType\DgArrayOfTextItemsTypeTextItem $textItems = null, $infoCode = null, $additionalDetailCode = null, $iD = null)
    {
        $this
            ->setImageItems($imageItems)
            ->setVideoItems($videoItems)
            ->setTextItems($textItems)
            ->setInfoCode($infoCode)
            ->setAdditionalDetailCode($additionalDetailCode)
            ->setID($iD);
    }
    /**
     * Get ImageItems value
     * @return \dgsoft\ArrayType\DgArrayOfImageItemsTypeImageItem|null
     */
    public function getImageItems()
    {
        return $this->ImageItems;
    }
    /**
     * Set ImageItems value
     * @param \dgsoft\ArrayType\DgArrayOfImageItemsTypeImageItem $imageItems
     * @return \dgsoft\StructType\DgMultimediaDescriptionType
     */
    public function setImageItems(\dgsoft\ArrayType\DgArrayOfImageItemsTypeImageItem $imageItems = null)
    {
        $this->ImageItems = $imageItems;
        return $this;
    }
    /**
     * Get VideoItems value
     * @return \dgsoft\ArrayType\DgArrayOfVideoItemsTypeVideoItem|null
     */
    public function getVideoItems()
    {
        return $this->VideoItems;
    }
    /**
     * Set VideoItems value
     * @param \dgsoft\ArrayType\DgArrayOfVideoItemsTypeVideoItem $videoItems
     * @return \dgsoft\StructType\DgMultimediaDescriptionType
     */
    public function setVideoItems(\dgsoft\ArrayType\DgArrayOfVideoItemsTypeVideoItem $videoItems = null)
    {
        $this->VideoItems = $videoItems;
        return $this;
    }
    /**
     * Get TextItems value
     * @return \dgsoft\ArrayType\DgArrayOfTextItemsTypeTextItem|null
     */
    public function getTextItems()
    {
        return $this->TextItems;
    }
    /**
     * Set TextItems value
     * @param \dgsoft\ArrayType\DgArrayOfTextItemsTypeTextItem $textItems
     * @return \dgsoft\StructType\DgMultimediaDescriptionType
     */
    public function setTextItems(\dgsoft\ArrayType\DgArrayOfTextItemsTypeTextItem $textItems = null)
    {
        $this->TextItems = $textItems;
        return $this;
    }
    /**
     * Get InfoCode value
     * @return string|null
     */
    public function getInfoCode()
    {
        return $this->InfoCode;
    }
    /**
     * Set InfoCode value
     * @param string $infoCode
     * @return \dgsoft\StructType\DgMultimediaDescriptionType
     */
    public function setInfoCode($infoCode = null)
    {
        // validation for constraint: string
        if (!is_null($infoCode) && !is_string($infoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoCode)), __LINE__);
        }
        $this->InfoCode = $infoCode;
        return $this;
    }
    /**
     * Get AdditionalDetailCode value
     * @return string|null
     */
    public function getAdditionalDetailCode()
    {
        return $this->AdditionalDetailCode;
    }
    /**
     * Set AdditionalDetailCode value
     * @param string $additionalDetailCode
     * @return \dgsoft\StructType\DgMultimediaDescriptionType
     */
    public function setAdditionalDetailCode($additionalDetailCode = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDetailCode) && !is_string($additionalDetailCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalDetailCode)), __LINE__);
        }
        $this->AdditionalDetailCode = $additionalDetailCode;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \dgsoft\StructType\DgMultimediaDescriptionType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgMultimediaDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
