<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MinimumStay StructType
 * @package Dg
 * @subpackage Structs
 */
class DgMinimumStay extends AbstractStructBase
{
    /**
     * The ReturnTimeOfDay
     * @var string
     */
    public $ReturnTimeOfDay;
    /**
     * The MinStay
     * @var int
     */
    public $MinStay;
    /**
     * The StayUnit
     * @var string
     */
    public $StayUnit;
    /**
     * The MinStayDate
     * @var string
     */
    public $MinStayDate;
    /**
     * The ComplicatedRulesInd
     * @var bool
     */
    public $ComplicatedRulesInd;
    /**
     * Constructor method for MinimumStay
     * @uses DgMinimumStay::setReturnTimeOfDay()
     * @uses DgMinimumStay::setMinStay()
     * @uses DgMinimumStay::setStayUnit()
     * @uses DgMinimumStay::setMinStayDate()
     * @uses DgMinimumStay::setComplicatedRulesInd()
     * @param string $returnTimeOfDay
     * @param int $minStay
     * @param string $stayUnit
     * @param string $minStayDate
     * @param bool $complicatedRulesInd
     */
    public function __construct($returnTimeOfDay = null, $minStay = null, $stayUnit = null, $minStayDate = null, $complicatedRulesInd = null)
    {
        $this
            ->setReturnTimeOfDay($returnTimeOfDay)
            ->setMinStay($minStay)
            ->setStayUnit($stayUnit)
            ->setMinStayDate($minStayDate)
            ->setComplicatedRulesInd($complicatedRulesInd);
    }
    /**
     * Get ReturnTimeOfDay value
     * @return string|null
     */
    public function getReturnTimeOfDay()
    {
        return $this->ReturnTimeOfDay;
    }
    /**
     * Set ReturnTimeOfDay value
     * @param string $returnTimeOfDay
     * @return \dgsoft\StructType\DgMinimumStay
     */
    public function setReturnTimeOfDay($returnTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($returnTimeOfDay) && !is_string($returnTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnTimeOfDay)), __LINE__);
        }
        $this->ReturnTimeOfDay = $returnTimeOfDay;
        return $this;
    }
    /**
     * Get MinStay value
     * @return int|null
     */
    public function getMinStay()
    {
        return $this->MinStay;
    }
    /**
     * Set MinStay value
     * @param int $minStay
     * @return \dgsoft\StructType\DgMinimumStay
     */
    public function setMinStay($minStay = null)
    {
        // validation for constraint: int
        if (!is_null($minStay) && !is_numeric($minStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minStay)), __LINE__);
        }
        $this->MinStay = $minStay;
        return $this;
    }
    /**
     * Get StayUnit value
     * @return string|null
     */
    public function getStayUnit()
    {
        return $this->StayUnit;
    }
    /**
     * Set StayUnit value
     * @uses \dgsoft\EnumType\DgStayUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgStayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stayUnit
     * @return \dgsoft\StructType\DgMinimumStay
     */
    public function setStayUnit($stayUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgStayUnitType::valueIsValid($stayUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stayUnit, implode(', ', \dgsoft\EnumType\DgStayUnitType::getValidValues())), __LINE__);
        }
        $this->StayUnit = $stayUnit;
        return $this;
    }
    /**
     * Get MinStayDate value
     * @return string|null
     */
    public function getMinStayDate()
    {
        return $this->MinStayDate;
    }
    /**
     * Set MinStayDate value
     * @param string $minStayDate
     * @return \dgsoft\StructType\DgMinimumStay
     */
    public function setMinStayDate($minStayDate = null)
    {
        // validation for constraint: string
        if (!is_null($minStayDate) && !is_string($minStayDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minStayDate)), __LINE__);
        }
        $this->MinStayDate = $minStayDate;
        return $this;
    }
    /**
     * Get ComplicatedRulesInd value
     * @return bool|null
     */
    public function getComplicatedRulesInd()
    {
        return $this->ComplicatedRulesInd;
    }
    /**
     * Set ComplicatedRulesInd value
     * @param bool $complicatedRulesInd
     * @return \dgsoft\StructType\DgMinimumStay
     */
    public function setComplicatedRulesInd($complicatedRulesInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($complicatedRulesInd) && !is_bool($complicatedRulesInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($complicatedRulesInd)), __LINE__);
        }
        $this->ComplicatedRulesInd = $complicatedRulesInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgMinimumStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
