<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaxLayoverPerConnection StructType
 * @package Dg
 * @subpackage Structs
 */
class DgMaxLayoverPerConnection extends AbstractStructBase
{
    /**
     * The Hour
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Hour;
    /**
     * The Minute
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Minute;
    /**
     * Constructor method for MaxLayoverPerConnection
     * @uses DgMaxLayoverPerConnection::setHour()
     * @uses DgMaxLayoverPerConnection::setMinute()
     * @param int $hour
     * @param int $minute
     */
    public function __construct($hour = null, $minute = null)
    {
        $this
            ->setHour($hour)
            ->setMinute($minute);
    }
    /**
     * Get Hour value
     * @return int
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param int $hour
     * @return \dgsoft\StructType\DgMaxLayoverPerConnection
     */
    public function setHour($hour = null)
    {
        // validation for constraint: int
        if (!is_null($hour) && !is_numeric($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get Minute value
     * @return int
     */
    public function getMinute()
    {
        return $this->Minute;
    }
    /**
     * Set Minute value
     * @param int $minute
     * @return \dgsoft\StructType\DgMaxLayoverPerConnection
     */
    public function setMinute($minute = null)
    {
        // validation for constraint: int
        if (!is_null($minute) && !is_numeric($minute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minute)), __LINE__);
        }
        $this->Minute = $minute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgMaxLayoverPerConnection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
