<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyCertificate StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLoyaltyCertificate extends AbstractStructBase
{
    /**
     * The ID_Context
     * @var string
     */
    public $ID_Context;
    /**
     * The NmbrOfNights
     * @var int
     */
    public $NmbrOfNights;
    /**
     * The Format
     * @var string
     */
    public $Format;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for LoyaltyCertificate
     * @uses DgLoyaltyCertificate::setID_Context()
     * @uses DgLoyaltyCertificate::setNmbrOfNights()
     * @uses DgLoyaltyCertificate::setFormat()
     * @uses DgLoyaltyCertificate::setStatus()
     * @param string $iD_Context
     * @param int $nmbrOfNights
     * @param string $format
     * @param string $status
     */
    public function __construct($iD_Context = null, $nmbrOfNights = null, $format = null, $status = null)
    {
        $this
            ->setID_Context($iD_Context)
            ->setNmbrOfNights($nmbrOfNights)
            ->setFormat($format)
            ->setStatus($status);
    }
    /**
     * Get ID_Context value
     * @return string|null
     */
    public function getID_Context()
    {
        return $this->ID_Context;
    }
    /**
     * Set ID_Context value
     * @param string $iD_Context
     * @return \dgsoft\StructType\DgLoyaltyCertificate
     */
    public function setID_Context($iD_Context = null)
    {
        // validation for constraint: string
        if (!is_null($iD_Context) && !is_string($iD_Context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD_Context)), __LINE__);
        }
        $this->ID_Context = $iD_Context;
        return $this;
    }
    /**
     * Get NmbrOfNights value
     * @return int|null
     */
    public function getNmbrOfNights()
    {
        return $this->NmbrOfNights;
    }
    /**
     * Set NmbrOfNights value
     * @param int $nmbrOfNights
     * @return \dgsoft\StructType\DgLoyaltyCertificate
     */
    public function setNmbrOfNights($nmbrOfNights = null)
    {
        // validation for constraint: int
        if (!is_null($nmbrOfNights) && !is_numeric($nmbrOfNights)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nmbrOfNights)), __LINE__);
        }
        $this->NmbrOfNights = $nmbrOfNights;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \dgsoft\StructType\DgLoyaltyCertificate
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($format)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \dgsoft\StructType\DgLoyaltyCertificate
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLoyaltyCertificate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
