<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LengthOfStay StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLengthOfStay extends AbstractStructBase
{
    /**
     * The LOS_Pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLOS_Pattern
     */
    public $LOS_Pattern;
    /**
     * The Time
     * @var int
     */
    public $Time;
    /**
     * The TimeUnit
     * @var string
     */
    public $TimeUnit;
    /**
     * The OpenStatusIndicator
     * @var bool
     */
    public $OpenStatusIndicator;
    /**
     * The MinMaxMessageType
     * @var string
     */
    public $MinMaxMessageType;
    /**
     * Constructor method for LengthOfStay
     * @uses DgLengthOfStay::setLOS_Pattern()
     * @uses DgLengthOfStay::setTime()
     * @uses DgLengthOfStay::setTimeUnit()
     * @uses DgLengthOfStay::setOpenStatusIndicator()
     * @uses DgLengthOfStay::setMinMaxMessageType()
     * @param \dgsoft\StructType\DgLOS_Pattern $lOS_Pattern
     * @param int $time
     * @param string $timeUnit
     * @param bool $openStatusIndicator
     * @param string $minMaxMessageType
     */
    public function __construct(\dgsoft\StructType\DgLOS_Pattern $lOS_Pattern = null, $time = null, $timeUnit = null, $openStatusIndicator = null, $minMaxMessageType = null)
    {
        $this
            ->setLOS_Pattern($lOS_Pattern)
            ->setTime($time)
            ->setTimeUnit($timeUnit)
            ->setOpenStatusIndicator($openStatusIndicator)
            ->setMinMaxMessageType($minMaxMessageType);
    }
    /**
     * Get LOS_Pattern value
     * @return \dgsoft\StructType\DgLOS_Pattern|null
     */
    public function getLOS_Pattern()
    {
        return $this->LOS_Pattern;
    }
    /**
     * Set LOS_Pattern value
     * @param \dgsoft\StructType\DgLOS_Pattern $lOS_Pattern
     * @return \dgsoft\StructType\DgLengthOfStay
     */
    public function setLOS_Pattern(\dgsoft\StructType\DgLOS_Pattern $lOS_Pattern = null)
    {
        $this->LOS_Pattern = $lOS_Pattern;
        return $this;
    }
    /**
     * Get Time value
     * @return int|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param int $time
     * @return \dgsoft\StructType\DgLengthOfStay
     */
    public function setTime($time = null)
    {
        // validation for constraint: int
        if (!is_null($time) && !is_numeric($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get TimeUnit value
     * @return string|null
     */
    public function getTimeUnit()
    {
        return $this->TimeUnit;
    }
    /**
     * Set TimeUnit value
     * @uses \dgsoft\EnumType\DgTimeUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeUnit
     * @return \dgsoft\StructType\DgLengthOfStay
     */
    public function setTimeUnit($timeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTimeUnitType::valueIsValid($timeUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeUnit, implode(', ', \dgsoft\EnumType\DgTimeUnitType::getValidValues())), __LINE__);
        }
        $this->TimeUnit = $timeUnit;
        return $this;
    }
    /**
     * Get OpenStatusIndicator value
     * @return bool|null
     */
    public function getOpenStatusIndicator()
    {
        return $this->OpenStatusIndicator;
    }
    /**
     * Set OpenStatusIndicator value
     * @param bool $openStatusIndicator
     * @return \dgsoft\StructType\DgLengthOfStay
     */
    public function setOpenStatusIndicator($openStatusIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($openStatusIndicator) && !is_bool($openStatusIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($openStatusIndicator)), __LINE__);
        }
        $this->OpenStatusIndicator = $openStatusIndicator;
        return $this;
    }
    /**
     * Get MinMaxMessageType value
     * @return string|null
     */
    public function getMinMaxMessageType()
    {
        return $this->MinMaxMessageType;
    }
    /**
     * Set MinMaxMessageType value
     * @param string $minMaxMessageType
     * @return \dgsoft\StructType\DgLengthOfStay
     */
    public function setMinMaxMessageType($minMaxMessageType = null)
    {
        // validation for constraint: string
        if (!is_null($minMaxMessageType) && !is_string($minMaxMessageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minMaxMessageType)), __LINE__);
        }
        $this->MinMaxMessageType = $minMaxMessageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLengthOfStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
