<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCCBaggageFee StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLCCBaggageFee extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The Weight
     * @var string
     */
    public $Weight;
    /**
     * The MaxWeight
     * @var string
     */
    public $MaxWeight;
    /**
     * The Quantity
     * @var string
     */
    public $Quantity;
    /**
     * Constructor method for LCCBaggageFee
     * @uses DgLCCBaggageFee::setAmount()
     * @uses DgLCCBaggageFee::setCurrency()
     * @uses DgLCCBaggageFee::setWeight()
     * @uses DgLCCBaggageFee::setMaxWeight()
     * @uses DgLCCBaggageFee::setQuantity()
     * @param float $amount
     * @param string $currency
     * @param string $weight
     * @param string $maxWeight
     * @param string $quantity
     */
    public function __construct($amount = null, $currency = null, $weight = null, $maxWeight = null, $quantity = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency)
            ->setWeight($weight)
            ->setMaxWeight($maxWeight)
            ->setQuantity($quantity);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgLCCBaggageFee
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgLCCBaggageFee
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \dgsoft\StructType\DgLCCBaggageFee
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get MaxWeight value
     * @return string|null
     */
    public function getMaxWeight()
    {
        return $this->MaxWeight;
    }
    /**
     * Set MaxWeight value
     * @param string $maxWeight
     * @return \dgsoft\StructType\DgLCCBaggageFee
     */
    public function setMaxWeight($maxWeight = null)
    {
        // validation for constraint: string
        if (!is_null($maxWeight) && !is_string($maxWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxWeight)), __LINE__);
        }
        $this->MaxWeight = $maxWeight;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \dgsoft\StructType\DgLCCBaggageFee
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLCCBaggageFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
