<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSearchCriterionType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgItemSearchCriterionType extends AbstractStructBase
{
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPosition
     */
    public $Position;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddress
     */
    public $Address;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTelephone
     */
    public $Telephone;
    /**
     * The RefPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRefPoint[]
     */
    public $RefPoint;
    /**
     * The CodeRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCodeRef
     */
    public $CodeRef;
    /**
     * The HotelRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelRef[]
     */
    public $HotelRef;
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRadius
     */
    public $Radius;
    /**
     * The ExactMatch
     * @var bool
     */
    public $ExactMatch;
    /**
     * The ImportanceType
     * @var string
     */
    public $ImportanceType;
    /**
     * The Ranking
     * @var int
     */
    public $Ranking;
    /**
     * Constructor method for ItemSearchCriterionType
     * @uses DgItemSearchCriterionType::setPosition()
     * @uses DgItemSearchCriterionType::setAddress()
     * @uses DgItemSearchCriterionType::setTelephone()
     * @uses DgItemSearchCriterionType::setRefPoint()
     * @uses DgItemSearchCriterionType::setCodeRef()
     * @uses DgItemSearchCriterionType::setHotelRef()
     * @uses DgItemSearchCriterionType::setRadius()
     * @uses DgItemSearchCriterionType::setExactMatch()
     * @uses DgItemSearchCriterionType::setImportanceType()
     * @uses DgItemSearchCriterionType::setRanking()
     * @param \dgsoft\StructType\DgPosition $position
     * @param \dgsoft\StructType\DgAddress $address
     * @param \dgsoft\StructType\DgTelephone $telephone
     * @param \dgsoft\StructType\DgRefPoint[] $refPoint
     * @param \dgsoft\StructType\DgCodeRef $codeRef
     * @param \dgsoft\StructType\DgHotelRef[] $hotelRef
     * @param \dgsoft\StructType\DgRadius $radius
     * @param bool $exactMatch
     * @param string $importanceType
     * @param int $ranking
     */
    public function __construct(\dgsoft\StructType\DgPosition $position = null, \dgsoft\StructType\DgAddress $address = null, \dgsoft\StructType\DgTelephone $telephone = null, array $refPoint = array(), \dgsoft\StructType\DgCodeRef $codeRef = null, array $hotelRef = array(), \dgsoft\StructType\DgRadius $radius = null, $exactMatch = null, $importanceType = null, $ranking = null)
    {
        $this
            ->setPosition($position)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setRefPoint($refPoint)
            ->setCodeRef($codeRef)
            ->setHotelRef($hotelRef)
            ->setRadius($radius)
            ->setExactMatch($exactMatch)
            ->setImportanceType($importanceType)
            ->setRanking($ranking);
    }
    /**
     * Get Position value
     * @return \dgsoft\StructType\DgPosition|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \dgsoft\StructType\DgPosition $position
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setPosition(\dgsoft\StructType\DgPosition $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \dgsoft\StructType\DgAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \dgsoft\StructType\DgAddress $address
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setAddress(\dgsoft\StructType\DgAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \dgsoft\StructType\DgTelephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \dgsoft\StructType\DgTelephone $telephone
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setTelephone(\dgsoft\StructType\DgTelephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get RefPoint value
     * @return \dgsoft\StructType\DgRefPoint[]|null
     */
    public function getRefPoint()
    {
        return $this->RefPoint;
    }
    /**
     * Set RefPoint value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRefPoint[] $refPoint
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setRefPoint(array $refPoint = array())
    {
        foreach ($refPoint as $itemSearchCriterionTypeRefPointItem) {
            // validation for constraint: itemType
            if (!$itemSearchCriterionTypeRefPointItem instanceof \dgsoft\StructType\DgRefPoint) {
                throw new \InvalidArgumentException(sprintf('The RefPoint property can only contain items of \dgsoft\StructType\DgRefPoint, "%s" given', is_object($itemSearchCriterionTypeRefPointItem) ? get_class($itemSearchCriterionTypeRefPointItem) : gettype($itemSearchCriterionTypeRefPointItem)), __LINE__);
            }
        }
        $this->RefPoint = $refPoint;
        return $this;
    }
    /**
     * Add item to RefPoint value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRefPoint $item
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function addToRefPoint(\dgsoft\StructType\DgRefPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRefPoint) {
            throw new \InvalidArgumentException(sprintf('The RefPoint property can only contain items of \dgsoft\StructType\DgRefPoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RefPoint[] = $item;
        return $this;
    }
    /**
     * Get CodeRef value
     * @return \dgsoft\StructType\DgCodeRef|null
     */
    public function getCodeRef()
    {
        return $this->CodeRef;
    }
    /**
     * Set CodeRef value
     * @param \dgsoft\StructType\DgCodeRef $codeRef
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setCodeRef(\dgsoft\StructType\DgCodeRef $codeRef = null)
    {
        $this->CodeRef = $codeRef;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \dgsoft\StructType\DgHotelRef[]|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelRef[] $hotelRef
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setHotelRef(array $hotelRef = array())
    {
        foreach ($hotelRef as $itemSearchCriterionTypeHotelRefItem) {
            // validation for constraint: itemType
            if (!$itemSearchCriterionTypeHotelRefItem instanceof \dgsoft\StructType\DgHotelRef) {
                throw new \InvalidArgumentException(sprintf('The HotelRef property can only contain items of \dgsoft\StructType\DgHotelRef, "%s" given', is_object($itemSearchCriterionTypeHotelRefItem) ? get_class($itemSearchCriterionTypeHotelRefItem) : gettype($itemSearchCriterionTypeHotelRefItem)), __LINE__);
            }
        }
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Add item to HotelRef value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelRef $item
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function addToHotelRef(\dgsoft\StructType\DgHotelRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgHotelRef) {
            throw new \InvalidArgumentException(sprintf('The HotelRef property can only contain items of \dgsoft\StructType\DgHotelRef, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelRef[] = $item;
        return $this;
    }
    /**
     * Get Radius value
     * @return \dgsoft\StructType\DgRadius|null
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param \dgsoft\StructType\DgRadius $radius
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setRadius(\dgsoft\StructType\DgRadius $radius = null)
    {
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get ExactMatch value
     * @return bool|null
     */
    public function getExactMatch()
    {
        return $this->ExactMatch;
    }
    /**
     * Set ExactMatch value
     * @param bool $exactMatch
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setExactMatch($exactMatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($exactMatch) && !is_bool($exactMatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exactMatch)), __LINE__);
        }
        $this->ExactMatch = $exactMatch;
        return $this;
    }
    /**
     * Get ImportanceType value
     * @return string|null
     */
    public function getImportanceType()
    {
        return $this->ImportanceType;
    }
    /**
     * Set ImportanceType value
     * @param string $importanceType
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setImportanceType($importanceType = null)
    {
        // validation for constraint: string
        if (!is_null($importanceType) && !is_string($importanceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importanceType)), __LINE__);
        }
        $this->ImportanceType = $importanceType;
        return $this;
    }
    /**
     * Get Ranking value
     * @return int|null
     */
    public function getRanking()
    {
        return $this->Ranking;
    }
    /**
     * Set Ranking value
     * @param int $ranking
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public function setRanking($ranking = null)
    {
        // validation for constraint: int
        if (!is_null($ranking) && !is_numeric($ranking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ranking)), __LINE__);
        }
        $this->Ranking = $ranking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgItemSearchCriterionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
