<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsCoverageType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgInsCoverageType extends AbstractStructBase
{
    /**
     * The CoveredTravelers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCoveredTravelerType
     */
    public $CoveredTravelers;
    /**
     * The InsCoverageDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInsCoverageDetailType
     */
    public $InsCoverageDetail;
    /**
     * The PlanCode
     * @var string
     */
    public $PlanCode;
    /**
     * The PlanID
     * @var string
     */
    public $PlanID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The TypeID
     * @var string
     */
    public $TypeID;
    /**
     * Constructor method for InsCoverageType
     * @uses DgInsCoverageType::setCoveredTravelers()
     * @uses DgInsCoverageType::setInsCoverageDetail()
     * @uses DgInsCoverageType::setPlanCode()
     * @uses DgInsCoverageType::setPlanID()
     * @uses DgInsCoverageType::setName()
     * @uses DgInsCoverageType::setType()
     * @uses DgInsCoverageType::setTypeID()
     * @param \dgsoft\ArrayType\DgArrayOfCoveredTravelerType $coveredTravelers
     * @param \dgsoft\StructType\DgInsCoverageDetailType $insCoverageDetail
     * @param string $planCode
     * @param string $planID
     * @param string $name
     * @param string $type
     * @param string $typeID
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfCoveredTravelerType $coveredTravelers = null, \dgsoft\StructType\DgInsCoverageDetailType $insCoverageDetail = null, $planCode = null, $planID = null, $name = null, $type = null, $typeID = null)
    {
        $this
            ->setCoveredTravelers($coveredTravelers)
            ->setInsCoverageDetail($insCoverageDetail)
            ->setPlanCode($planCode)
            ->setPlanID($planID)
            ->setName($name)
            ->setType($type)
            ->setTypeID($typeID);
    }
    /**
     * Get CoveredTravelers value
     * @return \dgsoft\ArrayType\DgArrayOfCoveredTravelerType|null
     */
    public function getCoveredTravelers()
    {
        return $this->CoveredTravelers;
    }
    /**
     * Set CoveredTravelers value
     * @param \dgsoft\ArrayType\DgArrayOfCoveredTravelerType $coveredTravelers
     * @return \dgsoft\StructType\DgInsCoverageType
     */
    public function setCoveredTravelers(\dgsoft\ArrayType\DgArrayOfCoveredTravelerType $coveredTravelers = null)
    {
        $this->CoveredTravelers = $coveredTravelers;
        return $this;
    }
    /**
     * Get InsCoverageDetail value
     * @return \dgsoft\StructType\DgInsCoverageDetailType|null
     */
    public function getInsCoverageDetail()
    {
        return $this->InsCoverageDetail;
    }
    /**
     * Set InsCoverageDetail value
     * @param \dgsoft\StructType\DgInsCoverageDetailType $insCoverageDetail
     * @return \dgsoft\StructType\DgInsCoverageType
     */
    public function setInsCoverageDetail(\dgsoft\StructType\DgInsCoverageDetailType $insCoverageDetail = null)
    {
        $this->InsCoverageDetail = $insCoverageDetail;
        return $this;
    }
    /**
     * Get PlanCode value
     * @return string|null
     */
    public function getPlanCode()
    {
        return $this->PlanCode;
    }
    /**
     * Set PlanCode value
     * @param string $planCode
     * @return \dgsoft\StructType\DgInsCoverageType
     */
    public function setPlanCode($planCode = null)
    {
        // validation for constraint: string
        if (!is_null($planCode) && !is_string($planCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($planCode)), __LINE__);
        }
        $this->PlanCode = $planCode;
        return $this;
    }
    /**
     * Get PlanID value
     * @return string|null
     */
    public function getPlanID()
    {
        return $this->PlanID;
    }
    /**
     * Set PlanID value
     * @param string $planID
     * @return \dgsoft\StructType\DgInsCoverageType
     */
    public function setPlanID($planID = null)
    {
        // validation for constraint: string
        if (!is_null($planID) && !is_string($planID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($planID)), __LINE__);
        }
        $this->PlanID = $planID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \dgsoft\StructType\DgInsCoverageType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgInsCoverageType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TypeID value
     * @return string|null
     */
    public function getTypeID()
    {
        return $this->TypeID;
    }
    /**
     * Set TypeID value
     * @param string $typeID
     * @return \dgsoft\StructType\DgInsCoverageType
     */
    public function setTypeID($typeID = null)
    {
        // validation for constraint: string
        if (!is_null($typeID) && !is_string($typeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeID)), __LINE__);
        }
        $this->TypeID = $typeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgInsCoverageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
