<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsCoverageDetailType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgInsCoverageDetailType extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The CoverageRequirements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCoverageLimitType
     */
    public $CoverageRequirements;
    /**
     * The TotalTripQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripQuantity
     */
    public $TotalTripQuantity;
    /**
     * The MaximumTripLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTimeDurationType
     */
    public $MaximumTripLength;
    /**
     * The TotalTripCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripCost
     */
    public $TotalTripCost;
    /**
     * The CoveredTrips
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfInsCoverageDetailTypeCoveredTrip
     */
    public $CoveredTrips;
    /**
     * The DeliveryPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDistribPrefType[]
     */
    public $DeliveryPref;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The AutoRenew
     * @var bool
     */
    public $AutoRenew;
    /**
     * Constructor method for InsCoverageDetailType
     * @uses DgInsCoverageDetailType::setType()
     * @uses DgInsCoverageDetailType::setCoverageRequirements()
     * @uses DgInsCoverageDetailType::setTotalTripQuantity()
     * @uses DgInsCoverageDetailType::setMaximumTripLength()
     * @uses DgInsCoverageDetailType::setTotalTripCost()
     * @uses DgInsCoverageDetailType::setCoveredTrips()
     * @uses DgInsCoverageDetailType::setDeliveryPref()
     * @uses DgInsCoverageDetailType::setEffectiveDate()
     * @uses DgInsCoverageDetailType::setExpireDate()
     * @uses DgInsCoverageDetailType::setAutoRenew()
     * @param string $type
     * @param \dgsoft\ArrayType\DgArrayOfCoverageLimitType $coverageRequirements
     * @param \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripQuantity $totalTripQuantity
     * @param \dgsoft\StructType\DgTimeDurationType $maximumTripLength
     * @param \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripCost $totalTripCost
     * @param \dgsoft\ArrayType\DgArrayOfInsCoverageDetailTypeCoveredTrip $coveredTrips
     * @param \dgsoft\StructType\DgDistribPrefType[] $deliveryPref
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $autoRenew
     */
    public function __construct($type = null, \dgsoft\ArrayType\DgArrayOfCoverageLimitType $coverageRequirements = null, \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripQuantity $totalTripQuantity = null, \dgsoft\StructType\DgTimeDurationType $maximumTripLength = null, \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripCost $totalTripCost = null, \dgsoft\ArrayType\DgArrayOfInsCoverageDetailTypeCoveredTrip $coveredTrips = null, array $deliveryPref = array(), $effectiveDate = null, $expireDate = null, $autoRenew = null)
    {
        $this
            ->setType($type)
            ->setCoverageRequirements($coverageRequirements)
            ->setTotalTripQuantity($totalTripQuantity)
            ->setMaximumTripLength($maximumTripLength)
            ->setTotalTripCost($totalTripCost)
            ->setCoveredTrips($coveredTrips)
            ->setDeliveryPref($deliveryPref)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setAutoRenew($autoRenew);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \dgsoft\EnumType\DgInsCoverageDetailTypeType::valueIsValid()
     * @uses \dgsoft\EnumType\DgInsCoverageDetailTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgInsCoverageDetailTypeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \dgsoft\EnumType\DgInsCoverageDetailTypeType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CoverageRequirements value
     * @return \dgsoft\ArrayType\DgArrayOfCoverageLimitType|null
     */
    public function getCoverageRequirements()
    {
        return $this->CoverageRequirements;
    }
    /**
     * Set CoverageRequirements value
     * @param \dgsoft\ArrayType\DgArrayOfCoverageLimitType $coverageRequirements
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setCoverageRequirements(\dgsoft\ArrayType\DgArrayOfCoverageLimitType $coverageRequirements = null)
    {
        $this->CoverageRequirements = $coverageRequirements;
        return $this;
    }
    /**
     * Get TotalTripQuantity value
     * @return \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripQuantity|null
     */
    public function getTotalTripQuantity()
    {
        return $this->TotalTripQuantity;
    }
    /**
     * Set TotalTripQuantity value
     * @param \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripQuantity $totalTripQuantity
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setTotalTripQuantity(\dgsoft\StructType\DgInsCoverageDetailTypeTotalTripQuantity $totalTripQuantity = null)
    {
        $this->TotalTripQuantity = $totalTripQuantity;
        return $this;
    }
    /**
     * Get MaximumTripLength value
     * @return \dgsoft\StructType\DgTimeDurationType|null
     */
    public function getMaximumTripLength()
    {
        return $this->MaximumTripLength;
    }
    /**
     * Set MaximumTripLength value
     * @param \dgsoft\StructType\DgTimeDurationType $maximumTripLength
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setMaximumTripLength(\dgsoft\StructType\DgTimeDurationType $maximumTripLength = null)
    {
        $this->MaximumTripLength = $maximumTripLength;
        return $this;
    }
    /**
     * Get TotalTripCost value
     * @return \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripCost|null
     */
    public function getTotalTripCost()
    {
        return $this->TotalTripCost;
    }
    /**
     * Set TotalTripCost value
     * @param \dgsoft\StructType\DgInsCoverageDetailTypeTotalTripCost $totalTripCost
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setTotalTripCost(\dgsoft\StructType\DgInsCoverageDetailTypeTotalTripCost $totalTripCost = null)
    {
        $this->TotalTripCost = $totalTripCost;
        return $this;
    }
    /**
     * Get CoveredTrips value
     * @return \dgsoft\ArrayType\DgArrayOfInsCoverageDetailTypeCoveredTrip|null
     */
    public function getCoveredTrips()
    {
        return $this->CoveredTrips;
    }
    /**
     * Set CoveredTrips value
     * @param \dgsoft\ArrayType\DgArrayOfInsCoverageDetailTypeCoveredTrip $coveredTrips
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setCoveredTrips(\dgsoft\ArrayType\DgArrayOfInsCoverageDetailTypeCoveredTrip $coveredTrips = null)
    {
        $this->CoveredTrips = $coveredTrips;
        return $this;
    }
    /**
     * Get DeliveryPref value
     * @return \dgsoft\StructType\DgDistribPrefType[]|null
     */
    public function getDeliveryPref()
    {
        return $this->DeliveryPref;
    }
    /**
     * Set DeliveryPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDistribPrefType[] $deliveryPref
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setDeliveryPref(array $deliveryPref = array())
    {
        foreach ($deliveryPref as $insCoverageDetailTypeDeliveryPrefItem) {
            // validation for constraint: itemType
            if (!$insCoverageDetailTypeDeliveryPrefItem instanceof \dgsoft\StructType\DgDistribPrefType) {
                throw new \InvalidArgumentException(sprintf('The DeliveryPref property can only contain items of \dgsoft\StructType\DgDistribPrefType, "%s" given', is_object($insCoverageDetailTypeDeliveryPrefItem) ? get_class($insCoverageDetailTypeDeliveryPrefItem) : gettype($insCoverageDetailTypeDeliveryPrefItem)), __LINE__);
            }
        }
        $this->DeliveryPref = $deliveryPref;
        return $this;
    }
    /**
     * Add item to DeliveryPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDistribPrefType $item
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function addToDeliveryPref(\dgsoft\StructType\DgDistribPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDistribPrefType) {
            throw new \InvalidArgumentException(sprintf('The DeliveryPref property can only contain items of \dgsoft\StructType\DgDistribPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DeliveryPref[] = $item;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get AutoRenew value
     * @return bool|null
     */
    public function getAutoRenew()
    {
        return $this->AutoRenew;
    }
    /**
     * Set AutoRenew value
     * @param bool $autoRenew
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public function setAutoRenew($autoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoRenew) && !is_bool($autoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($autoRenew)), __LINE__);
        }
        $this->AutoRenew = $autoRenew;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgInsCoverageDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
