<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchCriteriaType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgHotelSearchCriteriaType extends AbstractStructBase
{
    /**
     * The Criterion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCriterion[]
     */
    public $Criterion;
    /**
     * The AvailableOnlyIndicator
     * @var bool
     */
    public $AvailableOnlyIndicator;
    /**
     * Constructor method for HotelSearchCriteriaType
     * @uses DgHotelSearchCriteriaType::setCriterion()
     * @uses DgHotelSearchCriteriaType::setAvailableOnlyIndicator()
     * @param \dgsoft\StructType\DgCriterion[] $criterion
     * @param bool $availableOnlyIndicator
     */
    public function __construct(array $criterion = array(), $availableOnlyIndicator = null)
    {
        $this
            ->setCriterion($criterion)
            ->setAvailableOnlyIndicator($availableOnlyIndicator);
    }
    /**
     * Get Criterion value
     * @return \dgsoft\StructType\DgCriterion[]|null
     */
    public function getCriterion()
    {
        return $this->Criterion;
    }
    /**
     * Set Criterion value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCriterion[] $criterion
     * @return \dgsoft\StructType\DgHotelSearchCriteriaType
     */
    public function setCriterion(array $criterion = array())
    {
        foreach ($criterion as $hotelSearchCriteriaTypeCriterionItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriteriaTypeCriterionItem instanceof \dgsoft\StructType\DgCriterion) {
                throw new \InvalidArgumentException(sprintf('The Criterion property can only contain items of \dgsoft\StructType\DgCriterion, "%s" given', is_object($hotelSearchCriteriaTypeCriterionItem) ? get_class($hotelSearchCriteriaTypeCriterionItem) : gettype($hotelSearchCriteriaTypeCriterionItem)), __LINE__);
            }
        }
        $this->Criterion = $criterion;
        return $this;
    }
    /**
     * Add item to Criterion value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCriterion $item
     * @return \dgsoft\StructType\DgHotelSearchCriteriaType
     */
    public function addToCriterion(\dgsoft\StructType\DgCriterion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCriterion) {
            throw new \InvalidArgumentException(sprintf('The Criterion property can only contain items of \dgsoft\StructType\DgCriterion, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Criterion[] = $item;
        return $this;
    }
    /**
     * Get AvailableOnlyIndicator value
     * @return bool|null
     */
    public function getAvailableOnlyIndicator()
    {
        return $this->AvailableOnlyIndicator;
    }
    /**
     * Set AvailableOnlyIndicator value
     * @param bool $availableOnlyIndicator
     * @return \dgsoft\StructType\DgHotelSearchCriteriaType
     */
    public function setAvailableOnlyIndicator($availableOnlyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableOnlyIndicator) && !is_bool($availableOnlyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableOnlyIndicator)), __LINE__);
        }
        $this->AvailableOnlyIndicator = $availableOnlyIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgHotelSearchCriteriaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
