<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgHotelReservationsType extends AbstractStructBase
{
    /**
     * The HotelReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelReservationType[]
     */
    public $HotelReservation;
    /**
     * The RoutingHops
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRoutingHopTypeRoutingHop
     */
    public $RoutingHops;
    /**
     * The WrittenConfInst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgWrittenConfInstType
     */
    public $WrittenConfInst;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * Constructor method for HotelReservationsType
     * @uses DgHotelReservationsType::setHotelReservation()
     * @uses DgHotelReservationsType::setRoutingHops()
     * @uses DgHotelReservationsType::setWrittenConfInst()
     * @uses DgHotelReservationsType::setTPA_Extensions()
     * @param \dgsoft\StructType\DgHotelReservationType[] $hotelReservation
     * @param \dgsoft\ArrayType\DgArrayOfRoutingHopTypeRoutingHop $routingHops
     * @param \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     */
    public function __construct(array $hotelReservation = array(), \dgsoft\ArrayType\DgArrayOfRoutingHopTypeRoutingHop $routingHops = null, \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this
            ->setHotelReservation($hotelReservation)
            ->setRoutingHops($routingHops)
            ->setWrittenConfInst($writtenConfInst)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get HotelReservation value
     * @return \dgsoft\StructType\DgHotelReservationType[]|null
     */
    public function getHotelReservation()
    {
        return $this->HotelReservation;
    }
    /**
     * Set HotelReservation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelReservationType[] $hotelReservation
     * @return \dgsoft\StructType\DgHotelReservationsType
     */
    public function setHotelReservation(array $hotelReservation = array())
    {
        foreach ($hotelReservation as $hotelReservationsTypeHotelReservationItem) {
            // validation for constraint: itemType
            if (!$hotelReservationsTypeHotelReservationItem instanceof \dgsoft\StructType\DgHotelReservationType) {
                throw new \InvalidArgumentException(sprintf('The HotelReservation property can only contain items of \dgsoft\StructType\DgHotelReservationType, "%s" given', is_object($hotelReservationsTypeHotelReservationItem) ? get_class($hotelReservationsTypeHotelReservationItem) : gettype($hotelReservationsTypeHotelReservationItem)), __LINE__);
            }
        }
        $this->HotelReservation = $hotelReservation;
        return $this;
    }
    /**
     * Add item to HotelReservation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelReservationType $item
     * @return \dgsoft\StructType\DgHotelReservationsType
     */
    public function addToHotelReservation(\dgsoft\StructType\DgHotelReservationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgHotelReservationType) {
            throw new \InvalidArgumentException(sprintf('The HotelReservation property can only contain items of \dgsoft\StructType\DgHotelReservationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelReservation[] = $item;
        return $this;
    }
    /**
     * Get RoutingHops value
     * @return \dgsoft\ArrayType\DgArrayOfRoutingHopTypeRoutingHop|null
     */
    public function getRoutingHops()
    {
        return $this->RoutingHops;
    }
    /**
     * Set RoutingHops value
     * @param \dgsoft\ArrayType\DgArrayOfRoutingHopTypeRoutingHop $routingHops
     * @return \dgsoft\StructType\DgHotelReservationsType
     */
    public function setRoutingHops(\dgsoft\ArrayType\DgArrayOfRoutingHopTypeRoutingHop $routingHops = null)
    {
        $this->RoutingHops = $routingHops;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return \dgsoft\StructType\DgWrittenConfInstType|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst
     * @return \dgsoft\StructType\DgHotelReservationsType
     */
    public function setWrittenConfInst(\dgsoft\StructType\DgWrittenConfInstType $writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgHotelReservationsType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgHotelReservationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
