<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservation StructType
 * @package Dg
 * @subpackage Structs
 */
class DgHotelReservation extends AbstractStructBase
{
    /**
     * The HotelID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $HotelID;
    /**
     * The RoomID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RoomID;
    /**
     * Constructor method for HotelReservation
     * @uses DgHotelReservation::setHotelID()
     * @uses DgHotelReservation::setRoomID()
     * @param int $hotelID
     * @param int $roomID
     */
    public function __construct($hotelID = null, $roomID = null)
    {
        $this
            ->setHotelID($hotelID)
            ->setRoomID($roomID);
    }
    /**
     * Get HotelID value
     * @return int
     */
    public function getHotelID()
    {
        return $this->HotelID;
    }
    /**
     * Set HotelID value
     * @param int $hotelID
     * @return \dgsoft\StructType\DgHotelReservation
     */
    public function setHotelID($hotelID = null)
    {
        // validation for constraint: int
        if (!is_null($hotelID) && !is_numeric($hotelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hotelID)), __LINE__);
        }
        $this->HotelID = $hotelID;
        return $this;
    }
    /**
     * Get RoomID value
     * @return int
     */
    public function getRoomID()
    {
        return $this->RoomID;
    }
    /**
     * Set RoomID value
     * @param int $roomID
     * @return \dgsoft\StructType\DgHotelReservation
     */
    public function setRoomID($roomID = null)
    {
        // validation for constraint: int
        if (!is_null($roomID) && !is_numeric($roomID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($roomID)), __LINE__);
        }
        $this->RoomID = $roomID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgHotelReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
